<?php

namespace App\Http\Controllers\backend\page\go_online;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\GoOnlineCreateWebsiteTheme;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Str;

class GoOnlineCreateWebsiteThemeController extends Controller
{
    public function edit($id)
    {
        $datas=GoOnlineCreateWebsiteTheme::where('go_online_create_website_id',$id)->get();
        return view('backend.page.go-online.create-website.theme',compact('datas','id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        foreach ($request->row as $photo){
            if(@$photo['title']){
                if(@$photo['old_id']){
                    $data= GoOnlineCreateWebsiteTheme::find($photo['old_id']);
                    $image_name     =  @$photo['image'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/go-online/theme/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/go-online/theme/'.$name_gen;
                        $data->image  =   $last_img;
                        if($photo['old_image']){
                            $unlink=@unlink($photo['old_image']);
                        }
                    }

                    $data->title=$photo['title'];
                    $data->description=$photo['description'];
                    $data->updated_by=Auth::user()->id;
                    $result=$data->save();
                }
                else{
                    $image_name     =  @$photo['image'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/go-online/theme/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/go-online/theme/'.$name_gen;

                        $data    =   new GoOnlineCreateWebsiteTheme();
                        $data->image  =   $last_img;
                        $data->go_online_create_website_id =$id;
                        $data->title=$photo['title'];
                        $data->description=$photo['description'];
                        $data->created_by=Auth::user()->id;
                        $result=$data->save();
                    }
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('go-online.create-website.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy(Request $request)
    {
        $data=GoOnlineCreateWebsiteTheme::find($request->id)->delete();
    }
}
