<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomeFeatures;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;

class HomeFeaturesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=HomeFeatures::all();
        return view('backend.page.home.features.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  = Language::all();
        return view('backend.page.home.features.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'language'=>'required',
        ]);

        $data    =   new HomeFeatures();

        //--------------------------------------
        $image_name     =   $request->file('image');
        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
        $path           =   public_path('upload/home/features/'.$name_gen);
        Image::make($image_name->getRealPath())->save($path);
        $last_img       =   'upload/home/features/'.$name_gen;
        $data->image            =   $last_img;

        //-----------------------------------------

        $data->title=$request->title;
        $data->language=$request->language;
        $data->created_by=Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.features.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $languages  = Language::all();
        $data       =   HomeFeatures::find($id);
        return view('backend.page.home.features.view',compact('data','languages'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  = Language::all();
        $data       =   HomeFeatures::find($id);
        return view('backend.page.home.features.edit',compact('data','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'language'=>'required',
        ]);

        $old_image=$request->old_image;

        $data= HomeFeatures::find($id);


        //--------------------------------------
        $image_name     =   $request->file('image');
        if($image_name){
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/features/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/home/features/'.$name_gen;
            $data->image            =   $last_img;
            if($old_image){
                $unlink=@unlink($old_image);
            }
        }
        //--------------------------------------
        $data->title=$request->title;
        $data->language=$request->language;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.features.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   HomeFeatures::find($id);
        if($data->post_status=='Trash'){
            $result=$data->delete();
        }else{
            $data->post_status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.features.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
