<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomeOurServices;
use App\Models\HomeOurServicesChild;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;

class HomeOurServicesController extends Controller
{
    public function index(){
        $datas=HomeOurServices::all();
        return view('backend.page.home.our-services.index',compact('datas'));
    }

    public function create(){
        $languages  = Language::all();
        return view('backend.page.home.our-services.add',compact('languages'));
    }

    public function store(Request $request){
        $request->validate([
            'image_1'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'image_2'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'button_text'=>'required',
            'button_link'=>'nullable|url',
            'language'=>'required',
            'description'=>'required',
        ]);

        $data    =   new HomeOurServices();
        //--------------------------------------
        $image_name_1     =   $request->file('image_1');
        $name_gen_1       =   hexdec(uniqid()).'.'.$image_name_1->getClientOriginalExtension();
        $path_1           =   public_path('upload/home/our-services/'.$name_gen_1);
        Image::make($image_name_1->getRealPath())->save($path_1);
        $last_img_1       =   'upload/home/our-services/'.$name_gen_1;
        $data->image_1            =   $last_img_1;
        //--------------------------------------
        $image_name_2     =   $request->file('image_2');
        $name_gen_2       =   hexdec(uniqid()).'.'.$image_name_2->getClientOriginalExtension();
        $path_2           =   public_path('upload/home/our-services/'.$name_gen_2);
        Image::make($image_name_2->getRealPath())->save($path_2);
        $last_img_2       =   'upload/home/our-services/'.$name_gen_2;
        $data->image_2            =   $last_img_2;
        //-----------------------------------------

        $data->title=$request->title;
        $data->description=$request->description;
        $data->button_text=$request->button_text;
        $data->button_link=$request->button_link;
        $data->language=$request->language;
        $data->created_by=Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.our-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function show($id){
        $languages  = Language::all();
        $data=HomeOurServices::find($id);
        $child_data=HomeOurServicesChild::where('home_our_services_id',$id)->get();
        return view('backend.page.home.our-services.view',compact('data','child_data','languages'));
    }

    public function edit($id){
        $languages  = Language::all();
        $data=HomeOurServices::find($id);
        $child_data=HomeOurServicesChild::where('home_our_services_id',$id)->get();
        return view('backend.page.home.our-services.edit',compact('data','child_data','languages'));
    }

    public function update(Request $request, $id){
        $request->validate([
            'image_1'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'image_2'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'button_text'=>'required',
            'button_link'=>'nullable|url',
            'language'=>'required',
            'description'=>'required',
            'child_title.*'=>'required',
        ]);

        $old_image_1=$request->old_image_1;
        $old_image_2=$request->old_image_2;

        $data= HomeOurServices::find($id);

        //--------------------------------------
        $image_name_1     =   $request->file('image_1');
        if($image_name_1){
            $name_gen_1       =   hexdec(uniqid()).'.'.$image_name_1->getClientOriginalExtension();
            $path_1           =   public_path('upload/home/our-services/'.$name_gen_1);
            Image::make($image_name_1->getRealPath())->save($path_1);
            $last_img_1       =   'upload/home/our-services/'.$name_gen_1;
            $data->image_1            =   $last_img_1;
            if($old_image_1){
                $unlink=@unlink($old_image_1);
            }
        }
        //--------------------------------------
        $image_name_2     =   $request->file('image_2');
        if($image_name_2){
            $name_gen_2       =   hexdec(uniqid()).'.'.$image_name_2->getClientOriginalExtension();
            $path_2           =   public_path('upload/home/our-services/'.$name_gen_2);
            Image::make($image_name_2->getRealPath())->save($path_2);
            $last_img_2       =   'upload/home/our-services/'.$name_gen_2;
            $data->image_2            =   $last_img_2;
            if($old_image_2){
                $unlink=@unlink($old_image_2);
            }
        }
        //-----------------------------------------
        $data->title=$request->title;
        $data->description=$request->description;
        $data->button_text=$request->button_text;
        $data->button_link=$request->button_link;
        $data->language=$request->language;
        $data->status=$request->status;
        $data->created_by=Auth::user()->id;
        $result=$data->update();


        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.our-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy($id)
    {
        $data       =   HomeOurServices::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
            $child_data=HomeOurServicesChild::where('home_our_services_id',$id)->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.our-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }





    public function linkEdit($id){
        $datas=HomeOurServicesChild::where('home_our_services_id',$id)->get();
        return view('backend.page.home.our-services.link',compact('datas','id'));
    }

    public function linkUpdate(Request $request, $id){
        $request->validate([
            'row.*.icon'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp',
            'row.*.title'=>'required',
            'row.*.link'=>'required',
        ]);
        foreach ($request->row as $photo){
            if(@$photo['title']){
                if(@$photo['old_id']){
                    $data= HomeOurServicesChild::find($photo['old_id']);
                    $image_name     =  @$photo['icon'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/home/our-services/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/home/our-services/'.$name_gen;
                        $data->icon  =   $last_img;
                        if($photo['old_icon']){
                            $unlink=@unlink($photo['old_icon']);
                        }
                    }

                    $data->title=$photo['title'];
                    $data->link=$photo['link'];
                    $result=$data->save();
                }
                else{
                    $image_name     =  @$photo['icon'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/home/our-services/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/home/our-services/'.$name_gen;

                        $data    =   new HomeOurServicesChild();
                        $data->icon  =   $last_img;
                        $data->home_our_services_id =$id;
                        $data->title=$photo['title'];
                        $data->link=$photo['link'];
                        $result=$data->save();
                    }
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.our-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function linkDestroy(Request $request){
        $data=HomeOurServicesChild::find($request->id)->delete();
    }
}
