<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use App\Models\HomeSection;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeSectionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($type)
    {
        $datas=HomeSection::where('type',$type)->get();
        return view('backend.page.home.section.index',compact('datas','type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($type)
    {
        $languages  = Language::all();
        return view('backend.page.home.section.add',compact('languages','type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store($type,Request $request)
    {
        $request->validate([
            'title_1'=>'required',
            'language'=>'required',
        ]);

        $check_data=HomeSection::where('type',$type)->where('language',$request->language)->where('status','Published')->count();
        if($check_data>0){
            $notification=array(
                'message'=>'Duplicate data!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data= new HomeSection();
        $data->type =$type;
        $data->title_1 =$request->title_1;
        $data->title_2 =$request->title_2;
        $data->description =$request->description;
        $data->button_text =$request->button_text;
        $data->button_link =$request->button_link;
        $data->language =$request->language;
        $data->created_by =Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home-page.section.list',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($type,$id)
    {
        $languages  = Language::all();
        $data       =   HomeSection::find($id);
        return view('backend.page.home.section.edit',compact('data','languages','type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $type, $id)
    {
        $request->validate([
            'language'=>'required',
            'title_1'=>'required',
        ]);

        $check_data=HomeSection::where('type',$type)->where('language',$request->language)->where('status','Published')->where('id','!=',$id)->count();
        if($check_data>=1){
            $notification=array(
                'message'=>'Duplicate data!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data=HomeSection::find($id);
        $data->title_1 =$request->title_1;
        $data->title_2 =$request->title_2;
        $data->description =$request->description;
        $data->button_text =$request->button_text;
        $data->button_link =$request->button_link;
        $data->language =$request->language;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home-page.section.list',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($type,$id)
    {
        $data       =   HomeSection::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home-page.section.list',$type)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
