<?php

namespace App\Http\Controllers\backend\page\industries;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
use App\Models\IndustriesKeyOfferings;

class IndustriesKeyOfferingsController extends Controller
{
    public function edit($id)
    {
        $datas=IndustriesKeyOfferings::where('industries_id',$id)->get();
        return view('backend.page.industries.industry.key-offerings',compact('datas','id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        foreach ($request->row as $photo){
            if(@$photo['title'] && $photo['description']){
                if(@$photo['old_id']){
                    $data= IndustriesKeyOfferings::find($photo['old_id']);
                    $image_name     =  @$photo['image'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/industry/key-offerings/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/industry/key-offerings/'.$name_gen;
                        $data->image  =   $last_img;
                        if($photo['old_image']){
                            $unlink=@unlink($photo['old_image']);
                        }
                    }

                    $data->title=$photo['title'];
                    $data->description=$photo['description'];
                    $data->updated_by=Auth::user()->id;
                    $result=$data->save();
                }
                else{
                    $image_name     =  @$photo['image'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/industry/key-offerings/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/industry/key-offerings/'.$name_gen;

                        $data    =   new IndustriesKeyOfferings();
                        $data->image  =   $last_img;
                        $data->industries_id =$id;
                        $data->title=$photo['title'];
                        $data->description=$photo['description'];
                        $data->created_by=Auth::user()->id;
                        $result=$data->save();
                    }
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('industries.industry.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function delete(Request $request)
    {
        $data=IndustriesKeyOfferings::find($request->id)->delete();
    }
}
