<?php

namespace App\Http\Controllers\backend\page\partner;

use App\Http\Controllers\Controller;
use App\Models\PartnerPageContent;
use App\Models\Language;
use App\Models\PartnerPageContract;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;

class ParentPageController extends Controller
{
    public function index()
    {
        $datas=PartnerPageContent::all();
        return view('backend.page.partner.index',compact('datas'));
    }

    public function create()
    {
        $languages  = Language::all();
        return view('backend.page.partner.add', compact('languages'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'banner_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'page_2_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'page_3_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'page_4_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'page_5_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'page_6_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',
            'page_7_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg',

            'title' => 'required',
            'sub_title' => 'required',
            'description' => 'required',
            'business_text' => 'required',
            'business_description' => 'required',
            'marketing_text' => 'required',
            'marketing_description' => 'required',
            'typical_benefits_text' => 'required',
            'typical_benefits_description' => 'required',
            'how_to_join_as_a_partner_text' => 'required',
            'how_to_join_as_a_partner_description' => 'required',

            'status_reject_text' => 'required',
            'status_under_process_text' => 'required',
            'status_success_text' => 'required',

            'language' => 'required',
            'meta_key' => 'required',
            'meta_title' => 'required',
            'meta_description' => 'required',
        ]);

        $check_data = PartnerPageContent::where('language', $request->language)->count();
        if ($check_data) {
            $notification = array(
                'message' => 'Title already exists!!.',
                'alert-type' => 'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data= new PartnerPageContent();
        $data->title=$request->title;
        $data->sub_title=$request->sub_title;
        $data->description=$request->description;
        $data->business_text=$request->business_text;
        $data->business_description=$request->business_description;
        $data->marketing_text=$request->marketing_text;
        $data->marketing_description=$request->marketing_description;
        $data->typical_benefits_text=$request->typical_benefits_text;
        $data->typical_benefits_description=$request->typical_benefits_description;
        $data->how_to_join_as_a_partner_text=$request->how_to_join_as_a_partner_text;
        $data->how_to_join_as_a_partner_description=$request->how_to_join_as_a_partner_description;
        $data->status_reject_text=$request->status_reject_text;
        $data->status_under_process_text=$request->status_under_process_text;
        $data->status_success_text=$request->status_success_text;
        $data->language=$request->language;
        $data->meta_key=$request->meta_key;
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->view_terms_of_use_text=$request->view_terms_of_use_text;
        $data->view_terms_of_use_link=$request->view_terms_of_use_link;
        $data->created_by=Auth::user()->id;

        $data->kyc_form_text = $request->kyc_form_text;
        $kyc_form = $request->file('kyc_form');
        if (!empty($kyc_form) && $kyc_form != null) {
            $path                       = hexdec(uniqid()) . "." . $kyc_form->extension();
            $kyc_form->move(public_path('upload/partner-page/'), $path);
            $data->kyc_form            =  'upload/partner-page/' . $path;
        }

        $ImageArray=array('banner_image','page_2_image','page_3_image','page_4_image','page_5_image','page_6_image','page_7_image');
        foreach($ImageArray as $slug){
            $header_icon_name     =   $request->file($slug);
            if($header_icon_name){
                $header_icon_name_gen       =   hexdec(uniqid()) . '.' . $header_icon_name->getClientOriginalExtension();
                $path           =   public_path('upload/partner-page/' . $header_icon_name_gen);
                Image::make($header_icon_name->getRealPath())->save($path);
                $last_img       =   'upload/partner-page/' . $header_icon_name_gen;
                $data->$slug            =   $last_img;
            }
        }
        $result = $data->save();
        if (@$result) {
            $notification = array(
                'message' => 'Record Created Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('user.partner-page.view')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data=PartnerPageContent::find($id);
        $languages  = Language::all();
        return view('backend.page.partner.edit', compact('languages', 'data'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'banner_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'page_2_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'page_3_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'page_4_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'page_5_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'page_6_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'page_7_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',

            'title' => 'required',
            'sub_title' => 'required',
            'description' => 'required',
            'business_text' => 'required',
            'business_description' => 'required',
            'marketing_text' => 'required',
            'marketing_description' => 'required',
            'typical_benefits_text' => 'required',
            'typical_benefits_description' => 'required',

            'how_to_join_as_a_partner_text' => 'required',
            'how_to_join_as_a_partner_description' => 'required',

            'status_reject_text' => 'required',
            'status_under_process_text' => 'required',
            'status_success_text' => 'required',

            'meta_key' => 'required',
            'meta_title' => 'required',
            'meta_description' => 'required',
        ]);

        $data = PartnerPageContent::find($id);
        $data->title = $request->title;
        $data->sub_title = $request->sub_title;
        $data->description = $request->description;
        $data->business_text = $request->business_text;
        $data->business_description = $request->business_description;
        $data->marketing_text = $request->marketing_text;
        $data->marketing_description = $request->marketing_description;
        $data->typical_benefits_text = $request->typical_benefits_text;
        $data->typical_benefits_description = $request->typical_benefits_description;
        $data->partnership_documents_text = $request->partnership_documents_text;
        $data->partnership_documents_description = $request->partnership_documents_description;
        $data->how_to_join_as_a_partner_text = $request->how_to_join_as_a_partner_text;
        $data->how_to_join_as_a_partner_description = $request->how_to_join_as_a_partner_description;
        $data->status_reject_text = $request->status_reject_text;
        $data->status_under_process_text = $request->status_under_process_text;
        $data->status_success_text = $request->status_success_text;
        $data->meta_key = $request->meta_key;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->kyc_form_text = $request->kyc_form_text;
        $data->view_terms_of_use_text=$request->view_terms_of_use_text;
        $data->view_terms_of_use_link=$request->view_terms_of_use_link;

        $kyc_form = $request->file('kyc_form');
        if (!empty($kyc_form) && $kyc_form != null) {
            $path                       = hexdec(uniqid()) . "." . $kyc_form->extension();
            $kyc_form->move(public_path('upload/partner-page/'), $path);
            $data->kyc_form            =  'upload/partner-page/' . $path;
        }

        $data->updated_by = Auth::user()->id;
        $ImageArray = array('banner_image', 'page_2_image', 'page_3_image', 'page_4_image', 'page_5_image', 'page_6_image', 'page_7_image');
        foreach ($ImageArray as $slug) {
            $header_icon_name     =   $request->file($slug);
            if ($header_icon_name) {
                $header_icon_name_gen       =   hexdec(uniqid()) . '.' . $header_icon_name->getClientOriginalExtension();
                $path           =   public_path('upload/partner-page/' . $header_icon_name_gen);
                Image::make($header_icon_name->getRealPath())->save($path);
                $last_img       =   'upload/partner-page/' . $header_icon_name_gen;
                $data->$slug            =   $last_img;
            }
        }
        $result = $data->save();
        if (@$result) {
            $notification = array(
                'message' => 'Record Updated Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('user.partner-page.view')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy($id)
    {
        //
    }

    public function contractEdit($id)
    {
        $data=PartnerPageContract::where('partner_page_contents_id',$id)->first();
        return view('backend.page.partner.contract', compact('data','id'));
    }
    public function contractUpdate(Request $request, $parent_id)
    {
        $request->validate([
            'banner_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'contract_page_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'contract_verification_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',

            'title' => 'nullable',
            'sub_title' => 'nullable',
            'partner_contract_text' => 'nullable',
            'partner_contract_description' => 'nullable',
            'benefits_of_partnership_text' => 'nullable',
            'benefits_of_partnership_description' => 'nullable',
            'typical_benefits_text' => 'nullable',
            'business_text' => 'nullable',
            'business_description_1' => 'nullable',
            'business_description_2' => 'nullable',
            
            'draft_agreement_text' => 'required',
            'draft_agreement_checkbox_text' => 'required',
            'contract_verification_description' => 'required',
        ]);


        $data = PartnerPageContract::where('partner_page_contents_id', $parent_id)->first();
        if(!$data){
            $data= new PartnerPageContract();
            $data->partner_page_contents_id= $parent_id;
        }
        $data->title = $request->title;
        $data->sub_title = $request->sub_title;
        $data->partner_contract_text = $request->partner_contract_text;
        $data->partner_contract_description = $request->partner_contract_description;
        $data->benefits_of_partnership_text = $request->benefits_of_partnership_text;
        $data->benefits_of_partnership_description = $request->benefits_of_partnership_description;
        $data->typical_benefits_text = $request->typical_benefits_text;
        $data->business_text = $request->business_text;
        $data->business_description_1 = $request->business_description_1;
        $data->business_description_2 = $request->business_description_2;
        $data->draft_agreement_text = $request->draft_agreement_text;
        $data->draft_agreement_checkbox_text = $request->draft_agreement_checkbox_text;
        $data->contract_verification_description = $request->contract_verification_description;

        $draft_agreement = $request->file('draft_agreement');
        if (!empty($draft_agreement) && $draft_agreement != null) {
            $path                       = hexdec(uniqid()) . ".". $draft_agreement->extension();
            $draft_agreement->move(public_path('upload/partner-page/'), $path);
            $data->draft_agreement            =  'upload/partner-page/' . $path;
        }
        $ImageArray = array('banner_image', 'contract_verification_image','contract_page_image');
        foreach ($ImageArray as $slug) {
            $header_icon_name     =   $request->file($slug);
            if ($header_icon_name) {
                $header_icon_name_gen       =   hexdec(uniqid()) . '.' . $header_icon_name->getClientOriginalExtension();
                $path           =   public_path('upload/partner-page/' . $header_icon_name_gen);
                Image::make($header_icon_name->getRealPath())->save($path);
                $last_img       =   'upload/partner-page/' . $header_icon_name_gen;
                $data->$slug            =   $last_img;
            }
        }

        $result = $data->save();
        if (@$result) {
            $notification = array(
                'message' => 'Record Updated Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('user.partner-page.view')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
