<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MessageManagement;
use App\Models\MessageManagementValue;
use App\Models\Language;

class MessageManagementController extends Controller
{

    public function index(){
        $datas=MessageManagementValue::all();
        return view('backend.page.general-page.message-management.index',compact('datas'));
    }

    public function create(){
        $languages      =   Language::all();
        $labels=MessageManagement::all();
        return view('backend.page.general-page.message-management.add',compact('languages','labels'));
    }

    public function store(Request $request){
        $request->validate([
            'key'=>'required',
            'value'=>'required',
            'language'=>'required',
        ]);
        $check_data=MessageManagementValue::where('key',$request->key)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new MessageManagementValue();
        $data->key       =   $request->key;
        $data->value        =   $request->value;
        $data->language     =   $request->language;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('message.page.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages      =   Language::all();
        $labels=MessageManagement::all();
        $data       =   MessageManagementValue::find($id);
        return view('backend.page.general-page.message-management.edit',compact('data','languages','labels'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'key'=>'required',
            'value'=>'required',
            'language'=>'required',
        ]);
        $check_data=MessageManagementValue::where('id','!=',$id)->where('key',$request->key)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    = MessageManagementValue::find($id);
        $data->key     =   $request->key;
        $data->value     =   $request->value;
        $data->language     =   $request->language;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('message.page.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   MessageManagementValue::find($id);
        $result=$data->delete();
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
