<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use App\Models\ContactUs;
use App\Models\CustomerNotification;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Providers\MessageManagementProvider;
use App\Models\GeneralPageManagement;
use App\Models\VissionAndMission;
use App\Models\EmailManagement;
use App\Models\ContactUsFormData;
use App\Models\Event;
use App\Models\EventDate;
use App\Models\EventFormData;
use App\Models\Notification;
use App\Providers\EmailProvider;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use stdClass;
use DateTime;
use Str;
use GuzzleHttp\Client;

class GeneralPageManageemntController extends Controller
{
    public function index($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $data=GeneralPageManagement::where('slug',$slug)->where('status','Published')->where('language',$language)->first();
            if($data){
                return view('frontend.user.general-page',compact('data'));
            }else{
                $data=VissionAndMission::where('slug',$slug)->where('status','Published')->where('language',$language)->first();
                if($data){
                    return view('frontend.user.vission-and-mission',compact('data'));
                }else{
                    $data=ContactUs::where('slug',$slug)->where('status','Published')->where('language',$language)->first();
                    if($data){
                        return view('frontend.user.contact-us',compact('data'));
                    }else{
                        $data=Event::where('slug',$slug)->where('status','Published')->where('language',$language)->first();
                        if($data){
                            $current_date=date('Y-m-d H:i:s');
                            $eventData=EventDate::where('status','Published')->where('datetime','>=',$current_date)->where('language',$language)->get();
                            return view('frontend.user.event',compact('data','eventData'));
                        }else{
                            return redirect()->back();
                        }
                    }
                }
            }
        }catch(\Exception $e){
            Log::error('General Page'.$e);
            return redirect()->back();
        }

    }

    public function ContactUsStore(Request $request){
        $request->validate([
            'f_name'=>'required',
            'l_name'=>'required',
            'email'=>'required|email',
            'calling_code'=>'required',
            'phone'=>'required',
        ]);
        try{
            $data=new ContactUsFormData();
            $data->f_name =$request->f_name ;
            $data->l_name =$request->l_name ;
            $data->email =$request->email ;
            $data->calling_code =$request->calling_code ;
            $data->phone =$request->phone ;
            $data->save();

            $emailList=EmailManagement::where('key','admin_email_address')->first();
            //thankyou mail
            EmailProvider::Email('customer_contact_us',$request->email,$request);

            //admin email
            EmailProvider::Email('admin_contact_us',$emailList->title,$request);
            return redirect()->back()->with('message',MessageManagementProvider::MessageManage("contact-us-thankyou"));
        }catch(\Exception $e) {
            Log::error('Contact Us form submit: '. $e);
            return redirect()->back()->with('message1','The account or domain may not exist, they may be blacklisted, or missing');
        }
    }

    function generateICS($zoomLink, $startTime, $duration, $subject, $description='')
    {
        $dtStart = (new DateTime($startTime))->format('Ymd\THis');
        $dtStamp = (new DateTime())->format('Ymd\THis');
        $uid = uniqid(); // Unique identifier for the event

        // iCalendar format
        $icsContent = "BEGIN:VCALENDAR\r\n";
        $icsContent .= "VERSION:2.0\r\n";
        $icsContent .= "PRODID:-//Aurobees//NONSGML Zoom Meeting//EN\r\n";
        $icsContent .= "CALSCALE:GREGORIAN\r\n";
        $icsContent .= "METHOD:REQUEST\r\n";
        $icsContent .= "BEGIN:VEVENT\r\n";
        $icsContent .= "UID:{$uid}\r\n";
        $icsContent .= "DTSTAMP:{$dtStamp}\r\n";
        $icsContent .= "DTSTART:{$dtStart}\r\n";
        $icsContent .= "DURATION:{$duration}\r\n";  
        $icsContent .= "SUMMARY:{$subject}\r\n";
        $icsContent .= "DESCRIPTION:{$description}\r\n";
        $icsContent .= "LOCATION:{$zoomLink}\r\n";
        $icsContent .= "URL:{$zoomLink}\r\n";
        $icsContent .= "STATUS:CONFIRMED\r\n";
        $icsContent .= "BEGIN:VALARM\r\n";
        $icsContent .= "TRIGGER:-PT15M\r\n";
        $icsContent .= "ACTION:DISPLAY\r\n";
        $icsContent .= "ORGANIZER:Aurobees\r\n";
        $icsContent .= "DESCRIPTION:Reminder\r\n";
        $icsContent .= "END:VALARM\r\n";
        $icsContent .= "END:VEVENT\r\n";
        $icsContent .= "END:VCALENDAR\r\n";

        return $icsContent;
    }

   

    public function EventStore(Request $request)
    {
        try {
            // Check if all required fields are present
            if ($request->event_id && $request->event_child_id && $request->f_name && $request->l_name && $request->email && $request->calling_code && $request->phone) {

                // Save event form data
                $data = new EventFormData();
                $data->event_id = $request->event_id;
                $data->event_child_id = $request->event_child_id;
                $data->f_name = $request->f_name;
                $data->l_name = $request->l_name;
                $data->email = $request->email;
                $data->calling_code = $request->calling_code;
                $data->phone = $request->phone;
                $data->save();

               
                // Prepare list object for the email content
                $list = new stdClass;
                $list->event_name = $data['EventChild']['title'];
                $list->event_date = date('d-m-Y h:i A', strtotime($data['EventChild']['datetime']));
                $list->event_description = $data['EventChild']['description'];
                $list->event_zoom_link =  $data['EventChild']['zoom_join_url'];
                $list->event_zoom_id = $data['EventChild']['zoom_id'];
                $list->event_zoom_password = $data['EventChild']['zoom_password'];

                // Merge request data with $list
                $list = (object)array_merge((array)$list, $request->all());

                // Generate ICS file
                $icsContent = $this->generateICS(
                    $list->event_zoom_link,
                    $data['EventChild']['datetime'],
                    $data['EventChild']['duration'],
                    $list->event_name,
                    "Meeting ID: {$list->event_zoom_id}, Password: {$list->event_zoom_password}"
                );

                // Save ICS content as a file
                $fileName = Str::slug(time()) . ".ics";
                $filePath = public_path('temp/') . $fileName;
                file_put_contents($filePath, $icsContent);

                // Notifications for event registration
                $notification = new Notification();
                $notification->notification_from = '5';
                $notification->table_id = $request->event_child_id;
                $notification->title = $request->f_name . ' ' . $request->l_name . ' has registered in the event.';
                $notification->description = 'Registered in event: <br><b>Event Name:</b>' . $data['EventChild']['title'] . ' <br><b>Event Date:</b>' . date('d-m-Y h:i A', strtotime($data['EventChild']['datetime']));
                $notification->save();
                
                if(Auth::check()){
                    // User notification
                    $userNotification = new CustomerNotification();
                    $userNotification->user_id = Auth::user()->id;
                    $userNotification->notification_from = '2';
                    $userNotification->notification = 'Registered event details:<br><b>Event Name:</b>' . $data['EventChild']['title'] . ' <br><b>Event Date:</b>' . date('d-m-Y h:i A', strtotime($data['EventChild']['datetime']));
                    $userNotification->save();
                }

                // Email to admin and customer
                $emailList = EmailManagement::where('key', 'admin_email_address')->first();
                EmailProvider::Email('customer_event', $request->email, $list, [$filePath]); // Send to customer
                EmailProvider::Email('admin_event', $emailList->title, $list); // Send to admin

                @unlink($filePath);

                $array['type'] = 'success';
                $array['message'] = 'success';
                return $array;

            } else {
                $message = MessageManagementProvider::MessageManage('please-fill-all-fields');
                $array['type'] = 'error';
                $array['message'] = $message;
                return $array;
            }

        } catch (\Exception $e) {
            Log::error('Event form submit error: ' . $e->getMessage());
            $message = MessageManagementProvider::MessageManage('domain-may-not-exist');
            $array['type'] = 'error';
            $array['message'] = $message;
            return $array;
        }
    }

}
