<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\HomeBrands;
use App\Models\HomeCloud;
use App\Models\HomeCustomersDerive;
use App\Models\HomeFeatures;
use App\Models\HomeIndustries;
use App\Models\HomeIntegratedSupply;
use App\Models\HomeOurServices;
use App\Models\HomeOurServicesChild;
use App\Models\HomeSection;
use App\Models\HomeSlider;
use App\Models\HomeSliderAuto;
use App\Models\Posts;
use Illuminate\Support\Facades\Log;

class HomeController extends Controller
{
    public function Home(){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $sliders=HomeSlider::where('status','Published')->where('language',$language)->limit(3)->get();
            $sliderAuto=HomeSliderAuto::where('status','Published')->where('language',$language)->get();
            $features=HomeFeatures::where('status','Published')->where('language',$language)->get();
            $integrated_supply=HomeIntegratedSupply::where('status','Published')->where('language',$language)->first();
            $our_services=HomeOurServices::where('status','Published')->where('language',$language)->limit(3)->get();
            $industries=HomeIndustries::where('status','Published')->where('language',$language)->limit(7)->get();
            $clouds=HomeCloud::where('status','Published')->where('language',$language)->get();
            $brands=HomeBrands::where('status','Published')->get();
            $customers_derive=HomeCustomersDerive::where('status','Published')->where('language',$language)->get();

            $section_our_service=HomeSection::where('type','our-service')->where('status','Published')->where('language',$language)->first();
            $section_industries=HomeSection::where('type','industries')->where('status','Published')->where('language',$language)->first();
            $section_cloud=HomeSection::where('type','cloud')->where('status','Published')->where('language',$language)->first();
            $section_latest_news=HomeSection::where('type','latest-news')->where('status','Published')->where('language',$language)->first();
            $section_brands=HomeSection::where('type','brands')->where('status','Published')->where('language',$language)->first();
            $section_customers_derive=HomeSection::where('type','customers-derive')->where('status','Published')->where('language',$language)->first();
            $section_blogs=HomeSection::where('type','blogs')->where('status','Published')->where('language',$language)->first();

            $latest_news=Posts::where('post_type','news')->where('post_status','Published')->where('language',$language)->orderBy('id', 'DESC')->limit(3)->get();
            $blogs=Posts::where('post_type','post')->where('post_status','Published')->where('language',$language)->orderBy('id', 'DESC')->limit(3)->get();

            return view('frontend.user.home',compact('sliderAuto','sliders','brands','clouds','customers_derive','industries','features','integrated_supply','our_services','latest_news','blogs','section_our_service','section_industries','section_cloud','section_latest_news','section_customers_derive','section_blogs','section_brands'));
        }catch(\Exception $e){
            Log::error('Home Page : '.$e);
            return redirect()->back();
        }
    }
}
