<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\BlogCategory;
use App\Models\Posts;
use Storage;
use File;

class NewsPageController extends Controller
{
    public function List(){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $datas=Posts::where('post_type','news')->where('post_status','Published')->where('language',$language)->orderBy('id', 'DESC')->paginate(6);
            if(!$datas->isEmpty()){
                return view('frontend.user.news.list',compact('datas'));
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }

    public function Category($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $categoryList=BlogCategory::where('type','news')->where('status','Published')->where('language','en')->where('slug',$slug)->orderBy('id', 'DESC')->first();
            if($categoryList){
                $datas=Posts::where('post_type','news')->where('post_status','Published')->where('language',$language)->where('blog_category_id',$categoryList->id)->orderBy('id', 'DESC')->paginate(6);
                return view('frontend.user.news.category',compact('datas','categoryList'));
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }

    public function Single($slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $data=Posts::where('post_type','news')->where('post_status','Published')->where('language','en')->where('post_slug',$slug)->first();
            if($data){
                $dataNew=Posts::where('post_type','news')->where('post_status','Published')->where('language',$language)->where('default_language_page',$data->id)->first();
                $data=($dataNew)?$dataNew:$data;
            }
            if(@$data->pdf){
                $d=str_replace('','',@$data->pdf);
                $filePath = public_path($d);
                $fileSize = File::size($filePath);
                $fileSize = round($fileSize / 1024,2); // Convert bytes to kilobytes
            }else{
                $fileSize='';
            }
            $datas=Posts::where('id','!=',$data->id)->where('post_type','news')->where('post_status','Published')->where('language',$language)->orderBy('id', 'DESC')->limit(3)->get();
            if($data){
                return view('frontend.user.news.single',compact('data','datas','fileSize'));
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
