<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\HelperServiceProvider;
use App\Models\Pricing;
use App\Models\PricingAddons;
use App\Models\PricingFeature;
use App\Models\Currency;
use App\Models\Industries;
use App\Models\PlanPricing;
use Illuminate\Support\Facades\Log;

use function PHPUnit\Framework\isNull;

class PricePageController extends Controller
{
    public function Price(Request $request ,$slug){
        try{
            $language=HelperServiceProvider::DefaultLanguage();
            $country=HelperServiceProvider::DefaultCountry($request);
            $currency=HelperServiceProvider::DefaultCurrency();
            $check_data=Industries::where('slug',$slug)->where('status','Published')->where('language','en')->first();
            if($check_data){
                $pricing=Pricing::where('lob_id',$check_data->id)->where('status','Published')->where('language','en')->first();
                $pricingNew=Pricing::where('lob_id',$check_data->id)->where('status','Published')->where('language',$language)->first();
                $priceID=$pricing->id;
                if($pricingNew){
                    $priceID=$pricingNew->id;
                    $pricingNew->id=$pricing->id;
                    $pricing=$pricingNew;
                }
                if($pricing){
                    $plan_list=PlanPricing::where('price_id',$pricing->id)->where('country_code',$country)->limit(4)->get();
                    if($plan_list->isEmpty()){
                        $plan_list=PlanPricing::where('price_id',$pricing->id)->where('country_code','Other')->limit(4)->get();
                        if($plan_list->isEmpty()){
                            $plan_list=PlanPricing::where('price_id',$pricing->id)->where('country_code','IN')->limit(4)->get();
                        }
                    }
                    $pricing_feature=PricingFeature::where('pricing_id',$priceID)->where('status','Published')->get();
                    if($plan_list && $pricing_feature){
                        return view('frontend.user.price',compact('pricing','pricing_feature','plan_list'));
                    }
                }
            }
            return redirect()->back();
        }catch(\Exception $e){
            Log::error('Price Page '.$e);
            return redirect()->back();
        }
    }
}
