<?php

namespace App\Http\Controllers\frontend\become_a_partner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Mail;
use App\Mail\UserMail;
use App\Mail\UserUpdateMail;
use App\Models\Notification;
use App\Models\EmailManagement;
use App\Models\MarketSectorsList;
use App\Models\PartnerDetailMetaData;
use App\Models\PartnerNotification;
use App\Models\PartnerPageContent;
use App\Models\PartnerPageContract;
use App\Providers\HelperServiceProvider;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use App\Models\StateList;
use App\Models\UserVerify;
use Illuminate\Support\Str;
use App\Providers\MessageManagementProvider;
use App\Providers\EmailProvider;
use stdClass;

class BecomeAPartnerRegistrationController extends Controller
{
    public function index(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();
        if ($partner_page_data) {
            return view('frontend.become_a_partner.registration.screen1', compact('partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function LoginInformation(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if(!Auth::check() && !$partner_registration_id && !$partner_registration_page_id && $partner_page_data){
            return view('frontend.become_a_partner.registration.screen2', compact('partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function LoginInformationStore(Request $request){
        $validateData = $request->validate([
            'email' => 'unique:users|required',
            'f_name' => 'required|min:2',
            'l_name' => 'required|min:2',
            'designation' => 'required|min:2',
            'calling_code' => 'required',
            'phone' => 'required|numeric',
            'password' => ['required', 'min:8', 'regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{8,}$/'],
            'password_confirmation' => ['required', 'min:8', 'same:password'],
        ], [
            'f_name.required' => 'Please enter first name.',
            'f_name.min' => 'First name must be greater than 2 characters long.',
            'l_name.required' => 'Please enter last name.',
            'l_name.min' => 'Last name must be greater than 2 characters long.',
            'email.unique' => 'User already exists. You can use <a href="'.route('forget.password.get').'">forget password</a> function or register with a different email address.',
            'email.required' => 'Please enter an email address.',
            'designation.required' => 'Please enter designation.',
            'phone.required' => 'Please enter a phone number.',
            'password.required' => 'Please enter a password.',
            'calling_code.required' => 'Please select a calling code.',
        ]);
        try{
            $input=array();
            $input['f_name']=ucwords($request->f_name);
            $input['l_name']=ucwords($request->l_name);
            $input['email']=$request->email;
            $input['calling_code']=$request->calling_code;
            $input['phone']=$request->phone;
            $input['role']='Partner';
            $input['password']=bcrypt($request->password);
            $result = User::create($input);
            if(@$result->id){
                $metaData=new PartnerDetailMetaData();
                $metaData->user_id=$result->id;
                $metaData->key='designation';
                $metaData->value=$request->designation;
                $metaData->save();
                //notification
                $notification=new Notification();
                $notification->notification_from= '2';
                $notification->table_id= $result->id;
                $notification->title=$request->f_name. ' '.$request->l_name.' has registered as a partner';
                $notification->description=$request->f_name.' Registered as partner <b>Email:</b>'.$request->email;
                $notification->save();

                $token = Str::random(64);
                $link=route('user.verify', ['token'=>$token,'email'=>$request->email]);
                $number=rand(10000,99999);
                UserVerify::create([
                    'user_id' => $result->id,
                    'token' => $token,
                    'otp' => $number
                ]);
                $emailList=EmailManagement::first();
                //otp mail
                $value=new stdClass();
                $value->f_name=$request->f_name;
                $value->l_name=$request->l_name;
                $value->otp=$number;
                EmailProvider::Email('become_a_partner_registration_registration_otp', $request->email, $value );

                $email=$request->email;
                $success_message=MessageManagementProvider::MessageManage('registration-success-message');
                return view('frontend.new_user.otp',compact('token','email','success_message'));
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            if(@$result->id){
                User::find(@$result->id)->delete();
                UserVerify::where('user_id',$result->id)->delete();
            }
            if(@$notification->id){
                Notification::find(@$notification->id)->delete();
            }
            Log::error('Partner Register Error Login Information Store: '. $e);
            $message = MessageManagementProvider::MessageManage('domain-may-not-exist');
            return redirect()->back()->with('message',$message);
        }
    }
    public function BasicInformation(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=3 && $partner_page_data){
            return view('frontend.become_a_partner.registration.screen3', compact('partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function BasicInformationStore(Request $request){
        $validateData = $request->validate([
            'how_did_you_hear_about_our_program' => 'required',
            'in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner' => 'required',
            'individual_business' => 'required',
        ], [
            'how_did_you_hear_about_our_program.required' => 'Please select How did you hear about our program.',
            'in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner.required' => 'Please select In what region do you want to represent Aurobees as a channel partner.',
            'individual_business.required' => 'Please check Individual / Business',
        ]);
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            if($partner_registration_id && $partner_registration_page_id==3){
                $order_meta=[
                    ['user_id'=>$partner_registration_id,'key'=>'how_did_you_hear_about_our_program', 'value'=>$request->how_did_you_hear_about_our_program],
                    ['user_id'=>$partner_registration_id,'key'=>'in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner', 'value'=>$request->in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner],
                    ['user_id'=>$partner_registration_id,'key'=>'individual_business', 'value'=>$request->individual_business]
                ];
                PartnerDetailMetaData::insert($order_meta);
                Session::put('partner_registration_page_id', 4);
                return redirect()->route('become-a-partner.company-information');
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            Log::error('Partner Register Error Basic Information Store: '. $e);
            return redirect()->back();
        }
    }
    public function CompanyInformation(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=4 && $partner_page_data){
            $state_list = StateList::all();
            return view('frontend.become_a_partner.registration.screen4', compact('state_list', 'partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function CompanyInformationStore(Request $request){
        $validateData = $request->validate([
            'company' => 'required|min:2',
            'country' => 'required|min:2',
            'statelist' => strtolower($request->country) === 'in' ? 'required' : 'nullable',
            'city' => 'required|min:2',
            'company_calling_code' => 'required',
            'company_phone' => 'required|numeric',
            'address' => 'required',
            'address_2' => 'required',
            'pincode' => strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'what_is_your_primary_business_domain_focus' => 'required',
            'primary_company_website_or_social_media_page' => 'required',
            'short_description_of_your_company' => 'required'
        ], [
            'city.required' => 'Please enter city name.',
            'address.required' => 'Please enter address line 1.',
            'address_2.required' => 'Please enter address line 2.',
            'company.required' => 'Please enter company name.',
            'country.required' => 'Please enter country name.',
            'company_phone.required' => 'Please enter a phone number.',
            'pincode.required' => 'Please enter a pincode.',
            'company_calling_code.required' => 'Please select a calling code.',
            'statelist.required' => 'Please select a state.',
            'what_is_your_primary_business_domain_focus.required' => 'Please enter Please enter What is your primary business domain focus.',
            'primary_company_website_or_social_media_page.required' => 'Please enter Please enter Primary Company Website or Social Media Page.',
            'short_description_of_your_company.required' => 'Please enter Please enter Short Description.',
        ]);
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            if($partner_registration_id && $partner_registration_page_id==4){

                //-------------unique code generate------------------
                $year = date("Y");
                $code=$year.'01';
                $fname=strtoupper(substr(trim($request->company),0,2));
                $gCode=$fname.$code;
                $rowCount=User::where('code',$gCode)->count();
                while($rowCount!=0){
                    $code++;
                    $gCode=$fname.$code;
                    $rowCount=User::where('code',$gCode)->count();
                }


                $data=User::find($partner_registration_id);
                $data->company= $request->company;
                $data->code= $gCode;
                $data->company= $request->company;
                $data->country= $request->country;
                $data->state= ($request->country=='IN')?$request->statelist:Null;
                $data->city= $request->city;
                $data->address= $request->address;
                $data->pincode= ($request->country=='AE')?Null:$request->pincode;
                $data->save();

                $order_meta=[
                    ['user_id'=>$partner_registration_id,'key'=>'what_is_your_primary_business_domain_focus', 'value'=>$request->what_is_your_primary_business_domain_focus],
                    ['user_id'=>$partner_registration_id,'key'=>'primary_company_website_or_social_media_page', 'value'=>$request->primary_company_website_or_social_media_page],
                    ['user_id'=>$partner_registration_id,'key'=>'short_description_of_your_company', 'value'=>$request->short_description_of_your_company],
                    ['user_id'=>$partner_registration_id,'key'=>'company_phone', 'value'=>$request->company_phone],
                    ['user_id'=>$partner_registration_id,'key'=>'address_2', 'value'=>$request->address_2],
                    ['user_id'=>$partner_registration_id,'key'=>'company_calling_code', 'value'=>$request->company_calling_code]
                ];
                PartnerDetailMetaData::insert($order_meta);
                Session::put('partner_registration_page_id', 5);
                return redirect()->route('become-a-partner.company-financial-information');
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            Log::error('Partner Register Error Company Information Store: '. $e);
            return redirect()->back();
        }
    }
    public function CompanyFinancialInformation(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=5 && $partner_page_data){
            $market_sectors_lists=MarketSectorsList::all();
            return view('frontend.become_a_partner.registration.screen5', compact('market_sectors_lists', 'partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function CompanyFinancialInformationStore(Request $request){
        $validateData = $request->validate([
            'what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year' => 'required',
            'do_you_have_a_single_primary_vertical_market' => 'required',
            'what_is_your_company_primary_vertical_market_focus' => 'required'
        ], [
            'what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year.required' => 'Please select What was the total sales and services revenue generated by your company in its last fiscal year (USD).',
            'do_you_have_a_single_primary_vertical_market.required' => 'Please select Do you have a single primary vertical market?.',
            'what_is_your_company_primary_vertical_market_focus.required' => 'Please select What is your company’s primary vertical market focus.'
        ]);
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            if($partner_registration_id && $partner_registration_page_id==5){
                $order_meta=[
                    ['user_id'=>$partner_registration_id,'key'=>'what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year', 'value'=>$request->what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year],
                    ['user_id'=>$partner_registration_id,'key'=>'face_to_face_field_sales', 'value'=>$request->face_to_face_field_sales],
                    ['user_id'=>$partner_registration_id,'key'=>'telephone_based_consultative_sales_resources', 'value'=>$request->telephone_based_consultative_sales_resources],
                    ['user_id'=>$partner_registration_id,'key'=>'via_internet_with_limited_human_interference', 'value'=>$request->via_internet_with_limited_human_interference],
                    ['user_id'=>$partner_registration_id,'key'=>'do_you_have_a_single_primary_vertical_market', 'value'=>$request->do_you_have_a_single_primary_vertical_market],
                    ['user_id'=>$partner_registration_id,'key'=>'what_is_your_company_primary_vertical_market_focus', 'value'=>$request->what_is_your_company_primary_vertical_market_focus]
                ];
                PartnerDetailMetaData::insert($order_meta);
                Session::put('partner_registration_page_id', 6);
                return redirect()->route('become-a-partner.company-financial-information2');
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            Log::error('Partner Register Error Company Financial Information Store: '. $e);
            return redirect()->back();
        }
    }
    public function CompanyFinancialInformation2(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=6 && $partner_page_data){
            return view('frontend.become_a_partner.registration.screen6',compact('partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function CompanyFinancialInformation2Store(Request $request){
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            if($partner_registration_id && $partner_registration_page_id==6){
                $order_meta=[
                    ['user_id'=>$partner_registration_id,'key'=>'total_number_of_employees', 'value'=>$request->total_number_of_employees],
                    ['user_id'=>$partner_registration_id,'key'=>'total_number_of_sales_employees', 'value'=>$request->total_number_of_sales_employees],
                    ['user_id'=>$partner_registration_id,'key'=>'total_number_of_services', 'value'=>$request->total_number_of_services],
                    ['user_id'=>$partner_registration_id,'key'=>'total_number_of_technical_support_employees', 'value'=>$request->total_number_of_technical_support_employees],
                    ['user_id'=>$partner_registration_id,'key'=>'total_number_of_marketing_employees', 'value'=>$request->total_number_of_marketing_employees]
                ];
                PartnerDetailMetaData::insert($order_meta);
                Session::put('partner_registration_page_id', 7);
                return redirect()->route('become-a-partner.company-documents-upload');
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            Log::error('Partner Register Error Company Financial Information Store: '. $e);
            return redirect()->back();
        }
    }
    public function CompanyDocumentsUpload(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=7 && $partner_page_data){
            $userList=User::find($partner_registration_id);
            $country=@$userList['Country']['name'];
            $country_code=$userList->country;
            return view('frontend.become_a_partner.registration.screen7',compact('country','country_code', 'partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function CompanyDocumentsUploadStore(Request $request){
        $validateData = $request->validate([
            'country_code' => 'required',
            'gst_number' => (strtolower($request->country_code) === 'in' || strtolower($request->country_code) === 'sg') ? 'required' : 'nullable',
            'pan_number' => strtolower($request->country_code) === 'in' ? 'required' : 'nullable',
            'pan_card_copy' => strtolower($request->country_code) === 'in' ? 'required|mimes:jpg,png,jpeg,pdf':'nullable' ,
            'aadhar_card_number' => strtolower($request->country_code) === 'in' ? 'required' : 'nullable',
            'aadhar_card_copy' => strtolower($request->country_code) === 'in' ? 'required|mimes:jpg,png,jpeg,pdf':'nullable',
            'acra_number' => strtolower($request->country_code) === 'sg' ? 'required' : 'nullable',
            'acra_profile_copy' => strtolower($request->country_code) === 'sg' ? 'required':'nullable',
            'trn_number' => strtolower($request->country_code) === 'ae' ? 'required' : 'nullable',
            'tax_registration_number' => (strtolower($request->country_code) === 'ae' || strtolower($request->country_code) === 'id') ? 'required' : 'nullable',
            'tax_registration_document' => (strtolower($request->country_code) === 'ae' || strtolower($request->country_code) === 'id') ? 'required':'nullable',
            'npwp_number' => strtolower($request->country_code) === 'id' ? 'required' : 'nullable',

            'company_address_proof' =>'required',
            'company_registration_copy' =>'required',
            'company_registration_number' => 'required|min:2',
            'passport_number' => 'required|min:2',
            'passport_copy' =>'required',
            'passport_size_photo' =>'required|mimes:jpg,png,jpeg,pdf',
            'partners_signature_copy' =>'required',
            'kyc_form' =>'required',
            'partner_agrement_and_confirm' => 'required',
        ], [
            'gst_number.required' => 'Please Enter GST Number.',
            'pan_number.required' => 'Please Enter PAN Number.',
            'pan_card_copy.required' => 'Please upload the PAN Card Copy.',
            'aadhar_card_number.required' => 'Please Enter Aadhar Card Number.',
            'aadhar_card_copy.required' => 'Please upload the Aadhar Card Copy.',
            'acra_number.required' => 'Please Enter ACRA Number.',
            'acra_profile_copy.required' => 'Please upload the ACRA profile copy.',
            'trn_number.required' => 'Please Enter TRN Number.',
            'tax_registration_number.required' => 'Please Enter tax registration number.',
            'tax_registration_document.required' => 'Please upload the tax registration document.',
            'npwp_number.required' => 'Please Enter NPWP Number.',

            'company_address_proof.required' => 'Please upload the Company Address Proof.',
            'company_registration_copy.required' => 'Please upload the Company Registration Copy.',
            'company_registration_number.required' => 'Please Enter Company Registration Number.',
            'passport_number.required' => 'Please Enter Passport Number.',
            'passport_copy.required' => 'Please upload the Passport Copy.',
            'passport_size_photo.required' => 'Please upload the Passport Size Photo.',
            'partners_signature_copy.required' => 'Please upload the Partners Signature Copy.',
            'kyc_form.required' => 'Please upload the KYC Form.',
            'partner_agrement_and_confirm.required' => 'Please accept term and condition.',
        ]);
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            if($partner_registration_id && $partner_registration_page_id ==7){

                $order_meta[]=['user_id'=>$partner_registration_id,'key'=>'company_registration_number', 'value'=>$request->company_registration_number];
                $order_meta[]=['user_id'=>$partner_registration_id,'key'=>'passport_number', 'value'=>$request->passport_number];
                $order_meta[]=['user_id'=>$partner_registration_id,'key'=>'partner_agrement_and_confirm', 'value'=>($request->partner_agrement_and_confirm)?'Yes':'No'];


                //country code in
                if(strtolower($request->country_code) === 'in'){
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'gst_number', 'value' => $request->gst_number];
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'pan_number', 'value' => $request->pan_number];
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'aadhar_card_number', 'value' => $request->aadhar_card_number];
                }
                //country code sg
                if(strtolower($request->country_code) === 'sg'){
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'acra_number', 'value' => $request->acra_number];
                }
                //country code id
                if(strtolower($request->country_code) === 'id'){
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'tax_registration_number', 'value' => $request->tax_registration_number];
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'npwp_number', 'value' => $request->npwp_number];
                }
                //country code ae
                if(strtolower($request->country_code) === 'ae'){
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'trn_number', 'value' => $request->trn_number];
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'tax_registration_number', 'value' => $request->tax_registration_number];
                }

                //pan card copy
                $pan_card_copy = $request->file('pan_card_copy');
                if (!empty($pan_card_copy) && $pan_card_copy != null) {
                    $path  = hexdec(uniqid()). "." . $pan_card_copy->extension();
                    $pan_card_copy->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'pan_card_copy', 'value' => $fullpath];
                }
                //aadhar card copy
                $aadhar_card_copy = $request->file('aadhar_card_copy');
                if (!empty($aadhar_card_copy) && $aadhar_card_copy != null) {
                    $path  = hexdec(uniqid()). "." . $aadhar_card_copy->extension();
                    $aadhar_card_copy->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'aadhar_card_copy', 'value' => $fullpath];
                }
                //acra profile copy
                $acra_profile_copy = $request->file('acra_profile_copy');
                if (!empty($acra_profile_copy) && $acra_profile_copy != null) {
                    $path  = hexdec(uniqid()). "." . $acra_profile_copy->extension();
                    $acra_profile_copy->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'acra_profile_copy', 'value' => $fullpath];
                }
                //tax registration document
                $tax_registration_document = $request->file('tax_registration_document');
                if (!empty($tax_registration_document) && $tax_registration_document != null) {
                    $path  = hexdec(uniqid()). "." . $tax_registration_document->extension();
                    $tax_registration_document->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'tax_registration_document', 'value' => $fullpath];
                }
                //company address proof
                $company_address_proof = $request->file('company_address_proof');
                if (!empty($company_address_proof) && $company_address_proof != null) {
                    $path  = hexdec(uniqid()). "." . $company_address_proof->extension();
                    $company_address_proof->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'company_address_proof', 'value' => $fullpath];
                }
                //company registration copy
                $company_registration_copy = $request->file('company_registration_copy');
                if (!empty($company_registration_copy) && $company_registration_copy != null) {
                    $path  = hexdec(uniqid()). "." . $company_registration_copy->extension();
                    $company_registration_copy->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'company_registration_copy', 'value' => $fullpath];
                }
                //passport copy
                $passport_copy = $request->file('passport_copy');
                if (!empty($passport_copy) && $passport_copy != null) {
                    $path  = hexdec(uniqid()). "." . $passport_copy->extension();
                    $passport_copy->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'passport_copy', 'value' => $fullpath];
                }
                //passport size photo
                $passport_size_photo = $request->file('passport_size_photo');
                if (!empty($passport_size_photo) && $passport_size_photo != null) {
                    $path  = hexdec(uniqid()). "." . $passport_size_photo->extension();
                    $passport_size_photo->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'passport_size_photo', 'value' => $fullpath];
                }
                //partners signature copy
                $partners_signature_copy = $request->file('partners_signature_copy');
                if (!empty($partners_signature_copy) && $partners_signature_copy != null) {
                    $path  = hexdec(uniqid()). "." . $partners_signature_copy->extension();
                    $partners_signature_copy->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'partners_signature_copy', 'value' => $fullpath];
                }
                //kyc form
                $kyc_form = $request->file('kyc_form');
                if (!empty($kyc_form) && $kyc_form != null) {
                    $path  = hexdec(uniqid()). "." . $kyc_form->extension();
                    $kyc_form->move(public_path('upload/partner/'), $path);
                    $fullpath   = 'upload/partner/' . $path;
                    $order_meta[] = ['user_id' => $partner_registration_id, 'key' => 'kyc_form', 'value' => $fullpath];
                }
                PartnerDetailMetaData::insert($order_meta);
                Session::put('partner_registration_page_id', 9);
                
                //notification admin
                $notification=new Notification();
                $notification->notification_from= '2';
                $notification->table_id= $partner_registration_id;
                $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner has upload KYC form';
                $notification->description='partner uploaded KYC document current partner status is under verification.';
                $notification->save();
                
                //notification partner
                $partner_notification=new PartnerNotification();
                $partner_notification->user_id =Auth::user()->id;
                $partner_notification->notification=MessageManagementProvider::MessageManage('kyc-document-uploaded-successfully');
                $partner_notification->save();
                
                
                //partner mail
                EmailProvider::Email('become_a_partner_registration_uploaded_document_or_fields_for_partner', Auth::user()->email, Auth::user() );
                //support mail
                $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
                EmailProvider::Email('become_a_partner_registration_uploaded_document_or_fields_for_support', $support_team_email_list->title,  Auth::user() );


                return redirect()->route('become-a-partner.profile-verification-summary')->with('status',true);
            }else{
                return redirect()->back();
            }
        }catch(\Exception $e){
            Log::error('Partner Register Error Company Documents Upload Store: '. $e);
            return redirect()->back();
        }

    }
    public function ThankYou(){
        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=8){
            return view('frontend.become_a_partner.registration.screen8');
        }else{
            return redirect()->back();
        }
    }
    public function ProfileVerificationSummary(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();

        $partner_registration_id=Session::get('partner_registration_id');
        $partner_registration_page_id=Session::get('partner_registration_page_id');
        if($partner_registration_id && $partner_registration_page_id>=9 && $partner_page_data){
            $market_sectors_lists=MarketSectorsList::all();
            $userList=User::find($partner_registration_id);
            $country=@$userList['Country']['name'];
            $country_code=$userList->country;
            return view('frontend.become_a_partner.registration.screen9', compact('market_sectors_lists','country','country_code', 'partner_page_data'));
        }else{
            return redirect()->back();
        }
    }
    public function ContractSubmission(){
        return view('frontend.become_a_partner.registration.screen10');
    }
    public function PreviewDetails(){
        $partner_registration_id=Session::get('partner_registration_id');
        $data=User::find($partner_registration_id);
        $partner_details=PartnerDetailMetaData::where('user_id',$partner_registration_id)->get();

        return view('frontend.become_a_partner.registration.preview-details',compact('data','partner_details'));
    }


    public function PartnerContract(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();
        if($partner_page_data){
            $partner_page_data=PartnerPageContract::where('partner_page_contents_id', $partner_page_data->id)->first();
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            $data=PartnerDetailMetaData::where('user_id',$partner_registration_id)->where('key','partner_contract')->where('verify','Reject')->first();
            $errormsg='';
            if($data){
                $errormsg=$data->remarks;
            }
            if($partner_registration_id && $partner_registration_page_id==11 && $partner_page_data){
                return view('frontend.become_a_partner.registration.screen11', compact('errormsg', 'partner_page_data'));
            }
        }
        return redirect()->back();

    }

    public function PartnerContractUpdate(Request $request){
        $validateData = $request->validate([
            'partner_contract' =>'required'
        ], [
            'partner_contract.required' => 'Please upload contract.'
        ]);
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            $passport_copy = $request->file('partner_contract');
            if (!empty($passport_copy) && $passport_copy != null) {
                $path  = hexdec(uniqid()). "." . $passport_copy->extension();
                $passport_copy->move(public_path('upload/partner/'), $path);
                $fullpath   = 'upload/partner/' . $path;
                $data=PartnerDetailMetaData::where('user_id',$partner_registration_id)->where('key','partner_contract')->first();
                if($data){
                    $data->delete();
                }
                $row=new PartnerDetailMetaData();
                $row->user_id=$partner_registration_id;
                $row->key='partner_contract';
                $row->value=$fullpath;
                $row->save();

                //notification
                $notification=new Notification();
                $notification->notification_from= '2';
                $notification->table_id= $partner_registration_id;
                $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner contract Uploaded';
                $notification->description='partner contract under process';
                $notification->save();
                
                //notification partner
                $partner_notification=new PartnerNotification();
                $partner_notification->user_id =Auth::user()->id;
                $partner_notification->notification=MessageManagementProvider::MessageManage('contract-uploaded-successfully');
                $partner_notification->save();
                
                //partner mail
                EmailProvider::Email('become_a_partner_registration_uploaded_partner_contract_for_partner', Auth::user()->email, Auth::user() );
                //support
                $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
                EmailProvider::Email('become_a_partner_registration_uploaded_partner_contract_for_support', $support_team_email_list->title, Auth::user() );

            }
            Session::put('partner_registration_page_id', 10);
            return redirect()->route('become-a-partner.contract-verification');
        }catch(\Exception $e){
            Log::error('Partner Register Error Partner Contract Update: '. $e);
            return redirect()->back();
        }
    }

    public function ContractVerification(){
        $language = HelperServiceProvider::DefaultLanguage();
        $partner_page_data = PartnerPageContent::where('status', 'Published')->where('language', $language)->first();
        if ($partner_page_data) {
            $partner_page_data = PartnerPageContract::where('partner_page_contents_id', $partner_page_data->id)->first();
            $partner_registration_id=Session::get('partner_registration_id');
            $partner_registration_page_id=Session::get('partner_registration_page_id');
            if($partner_registration_id && $partner_registration_page_id==10 && $partner_page_data){
                return view('frontend.become_a_partner.registration.screen10',compact('partner_page_data'));
            }
        }
        return redirect()->back();
    }


    public function InformationUpdate(Request $request){
        try{
            $partner_registration_id=Session::get('partner_registration_id');
            $listData=array('gst_number', 'pan_number', 'aadhar_card_number', 'acra_number', 'trn_number', 'tax_registration_number', 'npwp_number', 'company_registration_number','passport_number', 'partner_agrement_and_confirm'
            ,'designation','how_did_you_hear_about_our_program','in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner','individual_business'
            ,'address_2','company_phone','company_calling_code','what_is_your_primary_business_domain_focus' ,'primary_company_website_or_social_media_page','short_description_of_your_company'
            ,'what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year'
            ,'face_to_face_field_sales','telephone_based_consultative_sales_resources','via_internet_with_limited_human_interference','do_you_have_a_single_primary_vertical_market' ,'what_is_your_company_primary_vertical_market_focus' ,''
            ,'total_number_of_employees' ,'total_number_of_sales_employees' ,'total_number_of_services' ,'total_number_of_technical_support_employees' ,'total_number_of_marketing_employees' );

            foreach($listData as $data){
                if($data && $request->$data){
                    $item=PartnerDetailMetaData::where('user_id',$partner_registration_id)->where('key',$data)->where('verify','Reject')->first();
                    if($item){
                        $item->value=$request->$data;
                        $item->verify=NULL;
                        $item->remarks=NULL;
                        $item->save();
                    }
                }
            }

            $listDocument=array( 'pan_card_copy', 'aadhar_card_copy', 'acra_profile_copy', 'tax_registration_document', 'company_address_proof', 'company_registration_copy', 'passport_copy', 'passport_size_photo', 'partners_signature_copy', 'kyc_form' );
            foreach($listDocument as $data){
                if($data && @$request->file($data)){
                    $item=PartnerDetailMetaData::where('user_id',$partner_registration_id)->where('key',$data)->where('verify','Reject')->first();
                    if($item){
                        $passport_copy = $request->file($data);
                        if (!empty($passport_copy) && $passport_copy != null) {
                            $path  = hexdec(uniqid()). "." . $passport_copy->extension();
                            $passport_copy->move(public_path('upload/partner/'), $path);
                            $fullpath   = 'upload/partner/' . $path;

                            $item->value=$fullpath;
                            $item->verify=NULL;
                            $item->remarks=NULL;
                            $item->save();
                        }
                    }
                }
            }
            //notification
            $notification=new Notification();
            $notification->notification_from= '2';
            $notification->table_id= $partner_registration_id;
            $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner reuploaded/re-entered the rejected files and fields';
            $notification->description='partner reuploaded/re-entered the rejected files and fields';
            $notification->save();
    
            //notification partner
            $partner_notification=new PartnerNotification();
            $partner_notification->user_id =Auth::user()->id;
            $partner_notification->notification=MessageManagementProvider::MessageManage('rejected-files-fields-uploaded-successfully');
            $partner_notification->save();
            
            //partner mail
            EmailProvider::Email('become_a_partner_registration_uploaded_rejected_document_or_fields_for_partner', Auth::user()->email, Auth::user() );
            //support
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            EmailProvider::Email('become_a_partner_registration_uploaded_rejected_document_or_fields_for_support', $support_team_email_list->title, Auth::user() );

            return redirect()->route('become-a-partner.profile-verification-summary')->with('status',true);
        }catch(\Exception $e){
            Log::error('Partner Register Error Partner Contract Update: '. $e);
            return redirect()->back();
        }
    }

    public function PartnerReadNotification(){
        PartnerNotification::where('user_id',Auth::user()->id)->where("status", '0')->update(["status" => "1"]);
        return redirect()->back();
    }
}
