<?php

namespace App\Http\Controllers\frontend\customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CustomerDetail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\Facades\Image;
use App\Providers\MessageManagementProvider;
use App\Models\StateList;
use App\Models\CountryList;
use App\Models\CallingCode;
use App\Models\IndustryList;
use Illuminate\Support\Facades\Log;

class CustomerProfileController extends Controller
{
    public function index(){
        try{
            $state_list=StateList::all();
            $country_list=CountryList::all();
            $calling_code=CallingCode::all();
            $data=CustomerDetail::where('user_id',Auth::user()->id)->first();
            $industry_list =IndustryList::all();
            return view('frontend.customer.profile.index',compact('data','state_list','country_list','calling_code','industry_list'));
        }catch(\Exception $e){
            Log::error('Customer Profile page:'.$e);
            return redirect()->back();
        }
    }

    //update profile photo
    public function updatePhoto(Request $request){
        $request->validate([
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif', // Adjust the validation rules as needed
        ]);
        try{
            $oldImage=Auth::user()->profile_photo_path;
            $image_name     =   $request->file('photo');
            if($image_name){
                $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                $path           =   public_path('upload/user_image/'.$name_gen);
                Image::make($image_name->getRealPath())->save($path);
                $last_img       =   'upload/user_image/'.$name_gen;

                $data=User::find(Auth::user()->id);
                $data->profile_photo_path  =   $last_img;
                $result=$data->save();
                if($oldImage){
                    @unlink($oldImage);
                }
            }
            $message =MessageManagementProvider::MessageManage('customer-profile-photo-update-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Customer Profile update photo:'.$e);
            return;
        }
    }

    //remove profile photo
    public function removePhoto(Request $request){
        try{
            $oldImage=Auth::user()->profile_photo_path;
            $data=User::find(Auth::user()->id);
            $data->profile_photo_path  =   NULL;
            $result=$data->save();
            if($oldImage){
                @unlink($oldImage);
            }
            $message =MessageManagementProvider::MessageManage('customer-profile-photo-remove-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Customer Profile remove photo:'.$e);
            return;
        }
    }

    //update bio
    public function updateBio(Request $request){
        $validateData=$request->validate([
            'bio'=>'required',
        ]);
        try{
            //Customer Detail table
            $checkDetail=CustomerDetail::where('user_id',Auth::user()->id)->count();
            if($checkDetail==0){
                $detail=new CustomerDetail();
                $detail->user_id =Auth::user()->id;
            }else{
                $detail=CustomerDetail::where('user_id',Auth::user()->id)->first();
            }
            $detail->bio =$request->bio;
            $detail->save();
            $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Customer Profile bio update:'.$e);
            return;
        }
    }

    //companyInformationUpdate
    public function companyInformationUpdate(Request $request){
        $validateData=$request->validate([
            'company'=>'required|min:2',
            'country'=>'required',
            'pincode' => strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'state' => strtolower($request->country) === 'in' ? 'required' : 'nullable',
            'city'=>'required|min:2',
            'address'=>'required',
            'no_of_employee'=>'required',
            'industry'=>'required',
        ]);
        try{
            //user table
            auth()->user()->update([
                'company' => $request->company,
                'country' => $request->country,
                'city' => $request->city,
                'address' => $request->address,
                'pincode' =>strtolower($request->country) === 'ae' ? Null : $request->pincode,
                'state' => strtolower($request->country) === 'in' ? $request->state : null,
            ]);
            //Customer Detail table
            $checkDetail=CustomerDetail::where('user_id',Auth::user()->id)->count();
            if($checkDetail==0){
                $detail=new CustomerDetail();
                $detail->user_id=Auth::user()->id;
            }else{
                $detail=CustomerDetail::where('user_id',Auth::user()->id)->first();
            }
            $detail->no_of_employee =$request->no_of_employee;
            $detail->industry =$request->industry;
            $detail->save();
            $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Customer Profile company Information Update:'.$e);
            return ;
        }
    }

    //authorisedUserUpdate
    public function authorisedUserUpdate(Request $request){
        $validateData=$request->validate([
            'f_name'=>'required|min:2',
            'l_name'=>'required|min:2',
            'alternate_phone'=>'nullable|numeric',
            'designation'=>'required|min:2',
        ]);
        try{
            //user table
            auth()->user()->update([
                'f_name' => $request->f_name,
                'l_name' => $request->l_name,
            ]);
            //Customer Detail table
            $checkDetail=CustomerDetail::where('user_id',Auth::user()->id)->count();
            if($checkDetail==0){
                $detail=new CustomerDetail();
                $detail->user_id=Auth::user()->id;
            }else{
                $detail=CustomerDetail::where('user_id',Auth::user()->id)->first();
            }
            $detail->alternate_calling_code =$request->alternate_calling_code;
            $detail->alternate_phone =$request->alternate_phone;
            $detail->designation =$request->designation;
            $detail->save();
            $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Customer Profile authorised User Update:'.$e);
            return ;
        }
    }

    //billingInformation
    public function billingInformation(Request $request){
        $validateData=$request->validate([
            'billing_company_name'=>'required|min:2',
            'billing_country'=>'required|min:2',
            'billing_city'=>'required|min:2',
            'billing_address'=>'required|min:2',
            'billing_email'=>'required|min:2',
            'billing_phone'=>'required|min:2',
            'billing_calling_code'=>'required',
            'billing_pincode' => strtolower($request->billing_country) === 'ae' ? 'nullable' : 'required|numeric',
            'billing_state' => strtolower($request->billing_country) === 'in' ? 'required' : 'nullable',
        ]);
        try{
            //Customer Detail table
            $checkDetail=CustomerDetail::where('user_id',Auth::user()->id)->count();
            if($checkDetail==0){
                $detail=new CustomerDetail();
                $detail->user_id=Auth::user()->id;
            }else{
                $detail=CustomerDetail::where('user_id',Auth::user()->id)->first();
            }
            $detail->billing_company_name =$request->billing_company_name;
            $detail->billing_country =$request->billing_country;
            $detail->billing_state =strtolower($request->billing_country) === 'in' ? $request->billing_state : null;
            $detail->billing_city =$request->billing_city;
            $detail->billing_address =$request->billing_address;
            $detail->billing_pincode =strtolower($request->billing_country) === 'ae' ? Null : $request->billing_pincode;
            $detail->billing_email =$request->billing_email;
            $detail->billing_calling_code =$request->billing_calling_code;
            $detail->billing_phone =$request->billing_phone;
            $detail->save();
            $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Customer Profile billing Information:'.$e);
            return;
        }
    }

    //document
    public function documentUpdate(Request $request){
        $validateData=$request->validate([
            'acra_profile_copy' => 'nullable|mimes:jpeg,png,jpg,gif,pdf',
            'tax_registration_document' => 'nullable|mimes:jpeg,png,jpg,gif,pdf',
        ]);
        try{
            $checkDetail = CustomerDetail::where('user_id', Auth::user()->id)->count();
            if ($checkDetail == 0) {
                $detail = new CustomerDetail();
                $detail->user_id = Auth::user()->id;
            } else {
                $detail = CustomerDetail::where('user_id', Auth::user()->id)->first();
            }
            if($request->gst_number){$detail->gst_number = $request->gst_number;}
            if($request->pan_number){$detail->pan_number = $request->pan_number;}
            if($request->trn_number){$detail->trn_number = $request->trn_number;}
            if($request->acra_number){$detail->acra_number = $request->acra_number;}
            if($request->npwp_number){$detail->npwp_number = $request->npwp_number;}
            if($request->tax_registration_number){$detail->tax_registration_number = $request->tax_registration_number;}
            if($request->company_registration_number){$detail->company_registration_number = $request->company_registration_number;}
            //document 1
            $acra_profile_copy = $request->file('acra_profile_copy');
            if(!empty($acra_profile_copy) && $acra_profile_copy != null){
                $path               = hexdec(uniqid()).".".$acra_profile_copy->extension();
                $acra_profile_copy->move(public_path('upload/user_image/document/'), $path);
                $detail->acra_profile_copy = 'upload/user_image/document/'.$path;
            }
            //document 2
            $tax_registration_document = $request->file('tax_registration_document');
            if(!empty($tax_registration_document) && $tax_registration_document != null){
                $path = hexdec(uniqid()).".".$tax_registration_document->extension();
                $tax_registration_document->move(public_path('upload/user_image/document/'), $path);
                $detail->tax_registration_document = 'upload/user_image/document/'.$path;
            }
            $result=$detail->save();

            if($result){
                $documentsList= CustomerDetail::where('user_id',Auth::user()->id)->first();
                $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
                return response()->json(['message' => $message, 'documentsList'=>$documentsList], 200);
            }
            return response()->json(500);
        }catch(\Exception $e){
            Log::error('Customer Profile document Update:'.$e);
            return response()->json(500);
        }
    }

}
