<?php

namespace App\Http\Controllers\frontend\operation;

use App\Http\Controllers\Controller;
use App\Models\CallingCode;
use App\Models\CountryList;
use App\Models\IndustryList;
use App\Models\OrderMeta;
use App\Models\PricingAddonesPrice;
use App\Models\PricingAddons;
use App\Models\SubscriptionAddons;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Providers\HelperServiceProvider;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Log;
use App\Models\Pricing;
use App\Models\PlanPricing;
use App\Models\StateList;
use App\Models\Subscription;
use App\Models\GST;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\DB;
use Str;

class CheckoutPageController extends Controller
{
    public function index(){
        try{
            $session_data=Session::get('PlanPurchaseData');
            if($session_data){
                $request=json_decode($session_data);
                $priceGet=Pricing::where('id',$request->page_id)->where('status','Published')->first();
                $priceChildGet=PlanPricing::where('id',$request->child_page_id)->where('price_id',$request->page_id)->first();

                if($priceGet && $priceChildGet){
                    $currency= $priceChildGet->currency;
                    $subscription_name=$priceGet['LOB']['title'];
                    $show_no_of_user= $no_of_user=$request->no_of_user;
                    if($priceChildGet->plan_type=='Free-Trial'){
                        $plan_type='Free Trial';
                        $show_no_of_user= $no_of_user=1;
                    }elseif($priceChildGet->plan_type=='Basic'){
                        $plan_type='Basic';
                    }elseif($priceChildGet->plan_type=='Advance'){
                        $plan_type='Advance';
                    }elseif($priceChildGet->plan_type=='Ecommerce'){
                        $plan_type='Go Ecommerce';
                        $no_of_user=$priceChildGet->no_of_order;
                        $show_no_of_user= 1;
                    }

                    //plan duration
                    if($request->switchPlanEcommerce){
                        $switchPlan=$request->switchPlanEcommerce;
                    }elseif($request->switchPlanAdvance){
                        $switchPlan=$request->switchPlanAdvance;
                    }elseif($request->switchPlanBasic){
                        $switchPlan=$request->switchPlanBasic;
                    }else{
                        $switchPlan='';
                    }

                    if($switchPlan=='MTH'){
                        $plan_duration='Monthly';
                        $plan_rate=number_format($priceChildGet->monthly, 2, ".", "");
                    }elseif($switchPlan=='QTR'){
                        $plan_duration='Quarterly';
                        $plan_rate=number_format($priceChildGet->quaterly, 2, ".", "");
                    }elseif($switchPlan=='YLY'){
                        $plan_duration='Yearly';
                        $plan_rate=number_format($priceChildGet->yearly, 2, ".", "");
                    }else{
                        $plan_rate=0.00;
                        $plan_duration='Trial';
                    }

                    //addon price 
                    $addon_rate=0;
                    $addonNameList=[];
                    if($plan_type=='Basic' ||$plan_type=='Advance'){
                        $price_addon= $request->price_addon;
                        if($price_addon){
                            $price_addon_array=explode(',',$price_addon);
                            if($price_addon_array){
                                $addon=0;
                                foreach($price_addon_array as $price_addon_id){
                                    if($price_addon_id){
                                        $PriceAddonList=PricingAddons::find($price_addon_id);
                                        if($PriceAddonList){
                                            $priceAddonPriceList=PricingAddonesPrice::where('pricing_addon_id', $price_addon_id)->where('plan_type', $plan_type)->where('country_code', $priceChildGet->country_code)->first();
                                            if($priceAddonPriceList){
                                                if($switchPlan=='MTH'){ 
                                                    $addonNameList[$addon]['name']=$PriceAddonList->name;
                                                    $addonNameList[$addon]['rate']=$priceAddonPriceList->monthly;
                                                    $addon_rate +=$priceAddonPriceList->monthly;
                                                }elseif($switchPlan=='QTR'){ 
                                                    $addonNameList[$addon]['name']=$PriceAddonList->name;
                                                    $addonNameList[$addon]['rate']=$priceAddonPriceList->quaterly;
                                                    $addon_rate +=$priceAddonPriceList->quaterly;
                                                }elseif($switchPlan=='YLY'){
                                                    $addonNameList[$addon]['name']=$PriceAddonList->name;
                                                    $addonNameList[$addon]['rate']=$priceAddonPriceList->yearly;
                                                    $addon_rate +=$priceAddonPriceList->yearly;
                                                }
                                            }
                                        }
                                    }
                                    $addon++;
                                }
                            }
                        }
                    }
                    
                    //total section 
                    $rate= number_format($plan_rate+$addon_rate, 2, ".", "");
                    $plan_total_rate=number_format($plan_rate*$no_of_user, 2, ".", "");
                    $addon_total_rate=number_format($addon_rate*$no_of_user, 2, ".", "");
                    $total_amount=$total_rate=number_format($plan_total_rate+$addon_total_rate, 2, ".", "");
                    
                    //tax
                    $taxList = GST::where('country_code', $priceChildGet->country_code)->first();
                    if (!$taxList) {
                        $taxList = GST::where('country_code', 'Other')->first();
                    }
                    $tax_name=$taxList->tax_name;
                    $tax=number_format(($taxList->rate/100)* $total_rate, 2, ".", "");

                    $grand_amount  =  number_format($total_rate + $tax,2,".","");
                    $state_list = StateList::all();
                    $industry_list = IndustryList::all();
                    $country_code =$priceChildGet->country_code;
                    //session
                    $arraySession['page_id']=$request->page_id ;
                    $arraySession['country_code']=$priceChildGet->country_code ;
                    $arraySession['currency_code']=$priceChildGet->currency ;
                    $arraySession['plan_name']=$priceChildGet->plan_type;
                    $arraySession['plan_duration']=$switchPlan ;
                    $arraySession['plan_rate']=$plan_rate ;
                    $arraySession['addon_rate']=$addon_rate ;
                    $arraySession['rate']=$rate ;
                    $arraySession['quantity']=$no_of_user ;
                    $arraySession['plan_total_rate']=$plan_total_rate ;
                    $arraySession['addon_total_rate']=$addon_total_rate ;
                    $arraySession['total_rate']=$total_rate ;
                    $arraySession['subscription_name']=$subscription_name ;
                    $arraySession['addonNameList']=$addonNameList ;
                    $arraySession['tax']= $tax ;
                    $arraySession['tax_percentage']= $taxList->rate ;
                    $arraySession['tax_name']= $taxList->tax_name ;
                    $arraySession['grand_amount']= $grand_amount;
                    $arraySession['short_name']= $priceGet->short_name;
                    Session::put('PlanData', json_encode($arraySession));

                    return view('frontend.user.checkout',compact('subscription_name','plan_duration','plan_type','show_no_of_user','no_of_user','total_amount','currency','state_list','industry_list', 'tax', 'tax_name', 'grand_amount','country_code'));
                }
            }
            return redirect()->route('home');
        }catch(\Exception $e) {
            Log::error('Open Checkout page: '. $e);
            return redirect()->back();
        }
    }

    public function store(Request $request){
        $validateData=$request->validate([
            'country'=>'required',
            'payment_mode'=>'required',
            'state' => [
                function ($attribute, $value, $fail) use ($request) {
                    if ($request->input('country') == 'IN' && empty($value)) {
                        $fail('Please select state.');
                    }
                },
            ],
            'city'=>'required',
            'address_1'=>'required',
            'pincode'=> strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'industry'=>'required',
            'no_of_employee'=>'required',
            'f_name'=>'required',
            'l_name'=>'required',
            'designation'=>'required',
            'address'=>'required',
            'email'=>'required|email',
            'calling_code'=>'required',
            'phone'=>'required|numeric',
            'billing_company_name'=>'required',
            'billing_country'=>'required',
            'billing_state' => [
                function ($attribute, $value, $fail) use ($request) {
                    if ($request->input('billing_country') == 'IN' && empty($value)) {
                        $fail('Please select state.');
                    }
                },
            ],
            'billing_city'=>'required',
            'billing_address_1'=>'required',
            'billing_email'=>'required|email',
            'billing_calling_code'=>'required',
            'billing_phone'=>'required|numeric',
        ],[
            'company_name.required' => 'Plaese enter company name.',
            'company_code.required' => 'Plaese enter company code.',
            'country.required' => 'Plaese select country.',
            'state.required' => 'Plaese enter state.',
            'select_list.required' => 'Plaese select state.',
            'city.required' => 'Plaese enter city name.',
            'address_1.required' => 'Plaese enter address.',
            'address_2.required' => 'Plaese enter address.',
            'pincode.required' => 'Plaese enter pincode.',
            'industry.required' => 'Plaese select industry.',
            'no_of_employee.required' => 'Plaese select Number of Employee.',
            'f_name.required' => 'Plaese enter first name.',
            'l_name.required' => 'Plaese enter last name.',
            'designation.required' => 'Plaese enter designation.',
            'address.required' => 'Plaese enter address.',
            'email.required' => 'Plaese enter email.',
            'email.email' => 'Plaese enter valid email.',
            'calling_code.required' => 'Plaese select calling code.',
            'phone.required' => 'Plaese enter phone number.',
            'billing_company_name.required' => 'Plaese enter company name.',
            'billing_country.required' => 'Plaese select country name.',
            'billing_state.required' => 'Plaese enter state name.',
            'billing_statelist.required' => 'Plaese select state name.',
            'billing_city.required' => 'Plaese enter city name.',
            'billing_address_1.required' => 'Plaese enter address.',
            'billing_address_2.required' => 'Plaese enter address.',
            'billing_email.required' => 'Plaese enter email.',
            'billing_calling_code.required' => 'Plaese select calling code.',
            'billing_phone.required' => 'Plaese enter phone number.',
            'payment_mode.*.required' => 'Plaese select payment mode.',
        ]);
        try{
            ///--------------------------------------------------
            $emailCheck=OrderMeta::where('key','email')->where('value',$request->email)->count();
            if($emailCheck>0){
                $emailCheck=OrderMeta::where('key','email')->where('value',$request->email)->get();
                foreach($emailCheck as $data){
                    if($data['Subscription']['status']=='Active'){
                        return redirect()->back()->with('message','Please use different email address.');
                        break;
                    }
                }
            }
            ///--------------------------------------------------
            //subscription   session value
            $PlanData=Session::get('PlanData');
            $item_detail=json_decode($PlanData);

            //serial number generate
            $currentYear = date('Y');
            $maxSubscriptionSlNo = Subscription::whereYear('created_at', $currentYear)->max('sl_no');
            if(!$maxSubscriptionSlNo){$maxSubscriptionSlNo=1;}else{ $maxSubscriptionSlNo=$maxSubscriptionSlNo+1; }
            $serialNumber='INV/'.$currentYear.'/'.$maxSubscriptionSlNo;

            // partner commission 
            $partner_commission_percentage =0;
            $partner_commission_amount =0;
            $partnerDetail=User::select('partner_commission_percentage')->where('code', Auth::user()->partner_code)->first();
            if($partnerDetail){
                $partner_commission_percentage=$partnerDetail->partner_commission_percentage;
                $partner_commission_amount=number_format(($partner_commission_percentage/100)*$item_detail->grand_amount ,2, ".","");
            }



            //Subscription table
            $item=new Subscription();
            $item->sl_no=$maxSubscriptionSlNo;
            $item->serial_number=$serialNumber;
            $item->user_id=Auth::user()->id;
            $item->plan_id=$item_detail->page_id;
            $item->plan_name=$item_detail->plan_name;
            $item->plan_duration=($item_detail->plan_duration)?$item_detail->plan_duration:'15 days';
            $item->country_code=$item_detail->country_code;
            $item->currency_code=$item_detail->currency_code;
            $item->plan_rate=$item_detail->plan_rate;
            $item->addon_rate=$item_detail->addon_rate;
            $item->rate=$item_detail->rate;
            $item->quantity=$item_detail->quantity;
            $item->plan_total_rate=$item_detail->plan_total_rate;
            $item->addon_total_rate=$item_detail->addon_total_rate;
            $item->total_rate=$item_detail->total_rate;
            $item->tax=$item_detail->tax;
            $item->tax_percentage=$item_detail->tax_percentage;
            $item->tax_name=$item_detail->tax_name;
            $item->grand_amount=$item_detail->grand_amount;
            $item->partner_commission_percentage=$partner_commission_percentage;
            $item->partner_commission_amount=$partner_commission_amount;
            $item->payment_mode=$request->payment_mode;
            $item->status='Pending';

            $item->save();

            $subscription_id=$item->id;

            //subscription addon 
            if($item_detail->addonNameList &&  is_array($item_detail->addonNameList)){
                foreach($item_detail->addonNameList as $addonItem){
                    $addonData=new SubscriptionAddons();
                    $addonData->subscription_id=$subscription_id;
                    $addonData->name=$addonItem->name;
                    $addonData->rate=$addonItem->rate;
                    $addonData->save();
                }
            }

            //order meta
            $state=($request->country=='IN')?$request->state:'';
            $billing_state=($request->billing_country=='IN')?$request->billing_state:'';
            //country
            $countryData=CountryList::where('code',$request->country)->first();
            $billingCountryData=CountryList::where('code',$request->billing_country)->first();
            //calling_code
            $callingCodeData=CallingCode::where('country_code',$request->calling_code)->first();
            $billingCallingCodeData=CallingCode::where('country_code',$request->billing_calling_code)->first();
            //industry
            $industry_list=IndustryList::find($request->industry);
            $industry=$industry_list->name;

            $order_meta=[
                ['subscription_id'=>$subscription_id,'key'=>'company_name', 'value'=>$request->company_name],
                ['subscription_id'=>$subscription_id,'key'=>'company_code', 'value'=>$request->company_code],
                ['subscription_id'=>$subscription_id,'key'=>'country', 'value'=>$countryData->name],
                ['subscription_id'=>$subscription_id,'key'=>'state', 'value'=>$state],
                ['subscription_id'=>$subscription_id,'key'=>'city', 'value'=>$request->city],
                ['subscription_id'=>$subscription_id,'key'=>'address_1', 'value'=>$request->address_1],
                ['subscription_id'=>$subscription_id,'key'=>'address_2', 'value'=>$request->address_2],
                ['subscription_id'=>$subscription_id,'key'=>'pincode', 'value'=>$request->pincode],
                ['subscription_id'=>$subscription_id,'key'=>'industry', 'value'=>$industry],
                ['subscription_id'=>$subscription_id,'key'=>'no_of_employee', 'value'=>$request->no_of_employee],
                ['subscription_id'=>$subscription_id,'key'=>'first_name', 'value'=>$request->f_name],
                ['subscription_id'=>$subscription_id,'key'=>'last_name', 'value'=>$request->l_name],
                ['subscription_id'=>$subscription_id,'key'=>'designation', 'value'=>$request->designation],
                ['subscription_id'=>$subscription_id,'key'=>'address', 'value'=>$request->address],
                ['subscription_id'=>$subscription_id,'key'=>'email', 'value'=>$request->email],
                ['subscription_id'=>$subscription_id,'key'=>'calling_code', 'value'=>$callingCodeData->code],
                ['subscription_id'=>$subscription_id,'key'=>'phone', 'value'=>$request->phone],
                ['subscription_id'=>$subscription_id,'key'=>'billing_company_name', 'value'=>$request->billing_company_name],
                ['subscription_id'=>$subscription_id,'key'=>'billing_country', 'value'=>$billingCountryData->name],
                ['subscription_id'=>$subscription_id,'key'=>'billing_state', 'value'=>$billing_state],
                ['subscription_id'=>$subscription_id,'key'=>'billing_city', 'value'=>$request->billing_city],
                ['subscription_id'=>$subscription_id,'key'=>'billing_address_1', 'value'=>$request->billing_address_1],
                ['subscription_id'=>$subscription_id,'key'=>'billing_address_2', 'value'=>$request->billing_address_2],
                ['subscription_id'=>$subscription_id,'key'=>'billing_email', 'value'=>$request->billing_email],
                ['subscription_id'=>$subscription_id,'key'=>'billing_calling_code', 'value'=>$billingCallingCodeData->code],
                ['subscription_id'=>$subscription_id,'key'=>'billing_phone', 'value'=>$request->billing_phone],
            ];
            //document
            if($request->gst_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'gst_number', 'value' => $request->gst_number];}
            if($request->pan_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'pan_number', 'value' => $request->pan_number];}
            if($request->trn_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'trn_number', 'value' => $request->trn_number];}
            if($request->acra_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'acra_number', 'value' => $request->acra_number];}
            if($request->npwp_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'npwp_number', 'value' => $request->npwp_number];}
            if($request->tax_registration_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'tax_registration_number', 'value' => $request->tax_registration_number];}
            if($request->company_registration_number){ $order_meta[]= ['subscription_id' => $subscription_id, 'key' => 'company_registration_number', 'value' => $request->company_registration_number];}
            //file
            $acra_profile_copy = $request->file('acra_profile_copy');
            if (!empty($acra_profile_copy) && $acra_profile_copy != null) {
                $fileExentsion              = $acra_profile_copy->extension();
                $fileFullName               = hexdec(uniqid());
                $path                       = Str::slug($fileFullName) . "." . $fileExentsion;
                $acra_profile_copy->move(public_path('upload/checkout/'), $path);
                $fullpath                   = 'upload/checkout/' . $path;
                $order_meta[] = ['subscription_id' => $subscription_id, 'key' => 'acra_profile_copy', 'value' => $fullpath];
            }elseif($request->acra_profile_copy_url && $request->acra_profile_copy_url!=NULL){
                $order_meta[] = ['subscription_id' => $subscription_id, 'key' => 'acra_profile_copy', 'value' => $request->acra_profile_copy_url];
            }
            //file
            $tax_registration_document = $request->file('tax_registration_document');
            if (!empty($tax_registration_document) && $tax_registration_document != null) {
                $fileExentsion              = $tax_registration_document->extension();
                $fileFullName               = hexdec(uniqid());
                $path                       = Str::slug($fileFullName) . "." . $fileExentsion;
                $tax_registration_document->move(public_path('upload/checkout/'), $path);
                $fullpath                   = 'upload/checkout/' . $path;
                $order_meta[] = ['subscription_id' => $subscription_id, 'key' => 'tax_registration_document', 'value' => $fullpath];
            }elseif($request->tax_registration_document_url && $request->tax_registration_document_url !=NULL){
                $order_meta[] = ['subscription_id' => $subscription_id, 'key' => 'tax_registration_document', 'value' => $request->tax_registration_document_url];
            }

            OrderMeta::insert($order_meta);

            //api data
            $apiData=array();
            $apiData['companyFullName']=$request->company_name;
            $apiData['addressLine1']=$request->address_1;
            $apiData['addressLine2']=$request->address_2;
            $apiData['city']=$request->city;
            $apiData['state']=$state;
            $apiData['country']=$countryData->name;
            $apiData['zipCode']=@$request->pincode;
            $apiData['industry']=$industry;
            $apiData['designation']=$request->designation;
            $apiData['noOfEmployees']=$item_detail->quantity;
            $apiData['taxRegistrationNo']='';
            $apiData['contactPersonFirstName']=$request->f_name;
            $apiData['contactPersonMiddleName']='';
            $apiData['contactPersonLastName']=$request->l_name;
            $apiData['contactPersonEmail']=$request->email;
            $apiData['contactPersonPhoneNo']=$request->phone;
            $apiData['webSiteUrl']='';
            $apiData['stateCode']='';
            $apiData['customerOf']='Aurobees';
            $apiData['companyCode']=$request->company_code;

            //'Free-Trial','Basic','Advance','Ecommerce'                 subscription type
            if($item_detail->plan_name=='Ecommerce'){
                $apiData['lob']='Ecom';
                $apiData['subscriptionType']='Paid';
                $apiData['isWoocommerceRequired']='Yes';
                $isWoocommerceRequired='Yes';
            }elseif(@$item_detail->short_name=='Ecom' && $item_detail->plan_name=='Free-Trial'){
                $apiData['lob']='Ecom';
                $apiData['subscriptionType']='Free';
                $apiData['isWoocommerceRequired']='Yes';
                $isWoocommerceRequired='Yes';
            }else{
                $apiData['lob']=$item_detail->short_name;
                if($item_detail->plan_name=='Free-Trial'){ $subscriptionType='FREE';}elseif($item_detail->plan_name=='Basic'){ $subscriptionType='Paid-Basic';}elseif($item_detail->plan_name=='Advance'){ $subscriptionType='Paid-Advanced';}
                $apiData['subscriptionType']=@$subscriptionType;
                $apiData['isWoocommerceRequired']='';
                $isWoocommerceRequired='No';
            }

            //transactions
            Session::forget('PlanData');
            Session::forget('PlanPurchaseData');
            Session::forget('CheckoutPageOldData');
            Session::put('apiData',json_encode($apiData));
            Session::put('subscription_id',$subscription_id);
            Session::put('isWoocommerceRequired',$isWoocommerceRequired);
            Session::put('grand_amount',$item_detail->grand_amount);
            Session::put('plan_name',$item_detail->plan_name);
            Session::put('plan_duration',$item_detail->plan_duration);
            Session::put('subscription_name',$item_detail->subscription_name);
            Session::put('currency_code',$item_detail->currency_code);
            Session::put('quantity',$item_detail->quantity);
            Session::put('payment_mode',$request->payment_mode);
            return redirect()->route('transactions');
        }catch(\Exception $e) {
            Log::error('Checkout page Store Data: '. $e);
            return redirect()->back();

        }
    }


    //unique email check--------------------------
    public function CheckUniqueEmailAjax(Request $request){
        $emailCheck=OrderMeta::where('key','email')->where('value',$request->email)->count();
        if($emailCheck==0){
            return false;
        }else{
            $emailCheck=OrderMeta::where('key','email')->where('value',$request->email)->get();
            foreach($emailCheck as $data){
                if($data['Subscription']['status']=='Active'){
                    return true;
                    break;
                }
            }
            return false;
        }
    }

    //store old value of checkout page current not in use
    public function OldValueCheckoutPageAjax(Request $request){
        try{
            $arraySession['address']=$request->address ;
            $arraySession['address_1']=$request->address_1 ;
            $arraySession['address_2']=$request->address_2 ;
            $arraySession['billing_address_1']=$request->billing_address_1 ;
            $arraySession['billing_address_2']=$request->billing_address_2 ;
            $arraySession['billing_calling_code']=$request->billing_calling_code ;
            $arraySession['billing_city']=$request->billing_city ;
            $arraySession['billing_company_name']=$request->billing_company_name ;
            $arraySession['billing_country']=$request->billing_country ;
            $arraySession['billing_email']=$request->billing_email ;
            $arraySession['billing_phone']=$request->billing_phone ;
            $arraySession['billing_state']=$request->billing_state ;
            $arraySession['calling_code']=$request->calling_code ;
            $arraySession['city']=$request->city ;
            $arraySession['company_code']=$request->company_code ;
            $arraySession['company_name']=$request->company_name ;
            $arraySession['country']=$request->country ;
            $arraySession['designation']=$request->designation ;
            $arraySession['email']=$request->email ;
            $arraySession['f_name']=$request->f_name ;
            $arraySession['industry']=$request->industry ;
            $arraySession['l_name']=$request->l_name ;
            $arraySession['no_of_employee']=$request->no_of_employee ;
            $arraySession['phone']=$request->phone ;
            $arraySession['pincode']=$request->pincode ;
            $arraySession['state']=$request->state ;
            $arraySession['trn_number']=$request->trn_number ;

            Session::put('CheckoutPageOldData', json_encode($arraySession));

            //session value
            $PlanData=Session::get('PlanData');
            $item_detail=json_decode($PlanData);
            $page_id=$item_detail->page_id;
            $priceTable=Pricing::find($page_id);
            $slug=$priceTable['LOB']['slug'];
            return route('price.page.view',$slug);
        }catch(\Exception $e){
            return false;
        }
    }
}
