<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Providers\MessageManagementProvider;

class AdministratorCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (@auth()->user()->role == 'Administrator' && @auth()->user()->status == 'N') {
            return $next($request);
        }
        session()->flush();
        $template=MessageManagementProvider::MessageManage('account-delete');
        return redirect('login')->with('massage',$template);
    }
}
