<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Providers\MessageManagementProvider;

class CustomerCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (@auth()->user()->role == 'Customer' && @auth()->user()->status == 'N') {
            return $next($request);
        }

        session()->flush();
        $template=MessageManagementProvider::MessageManage('account-delete-email-verify');
        return redirect('login')->with('message', $template);

    }
}
