<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use App\Providers\MessageManagementProvider;

class IsVerifyEmail
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::user()->is_email_verified) {
            $femail=substr(trim(Auth::user()->email),0,4);
            $email = strstr(Auth::user()->email, '@');
            $message=$femail.'********'.$email;
            session()->flush();
            $link=route('resend.otp');
            $link='<a href="'.$link.'">email validation</a>';
            $template=MessageManagementProvider::MessageManage('email-not-verified');
            @$text = array( "{EMAIL_ADDRESS}", "{LINK}");
            @$text_value   = array(@$message, $link);
            @$text = str_replace(@$text, @$text_value, @$template);
            return Redirect::route('login')->with('message', $text);
          }

        return $next($request);
    }
}
