<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;

class PartnerCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $date=date('Y-m-d');
        if (Auth::user()->role == 'Partner' && Auth::user()->status == 'N' && Auth::user()->agreement_from_date <= $date &&  Auth::user()->agreement_to_date >= $date ) {
            if(Session::get('approved_partner_status')){
                return $next($request);
            }
        }
        session()->flush();
        $message='Your account is deleted by admin or your agreement was expired.';
        return redirect('login')->with('message', $message);  
    }
}
