<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Subscription extends Model
{
    use HasFactory;
    public function User(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function Pricing(){
        return $this->belongsTo(Pricing::class,'plan_id','id');
    }

    public function OrderMeta(): HasMany {
        return $this->hasMany(OrderMeta::class,'subscription_id','id');
    }

    public function Transaction(): HasMany {
        return $this->hasMany(Transaction::class,'subscription_id','id');
    }

    public function SubscriptionAddons(): HasMany {
        return $this->hasMany(SubscriptionAddons::class,'subscription_id','id');
    }
}
