<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class VissionAndMission extends Model
{
    use HasFactory;

    public function Language(){
        return $this->belongsTo(Language::class,'language','code');
    }
    public function Feature(): HasMany {
        return $this->hasMany(VissionAndMissionFeature::class,'vission_mission_id','id');
    }
    public function OurCoreValues(): HasMany {
        return $this->hasMany(VissionAndMissionOurCoreValues::class,'vission_mission_id','id');
    }
}
