<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Mail;
use App\Models\EmailManagement;

class EmailProvider extends ServiceProvider
{
    // public static function Email(string $key, $email ,$value){

    //     $emailList=EmailManagement::where('key',$key)->first();
    //     Mail::send('emails.email', ['value'=>$value,'template'=>$emailList->template], function($message) use($email,$emailList){
    //         $message->to($email);
    //         $message->subject($emailList->title);
    //     });
    // }
    
    
    public static function Email(string $key, $email, $value, $files = []) {
        $emailList = EmailManagement::where('key', $key)->first();
        // Check if the email template exists
        if (!$emailList) {
            throw new \Exception("Email template with key '{$key}' not found.");
        }
        
        Mail::send('emails.email', ['value' => $value, 'template' => $emailList->template], function($message) use($email, $emailList, $files) {
            $message->to($email);
            $message->subject($emailList->title);
            
            // Check if file attachments are provided and attach each file
            if (!empty($files) && is_array($files)) {
                foreach ($files as $file) {
                    if (file_exists($file)) {
                        $message->attach($file);
                    } 
                }
            }
            if($emailList->file && file_exists($emailList->file)){
                $message->attach($emailList->file);
            }
        });
    }

}

