<?php

namespace App\Providers;

use App\Models\MessageManagement;
use App\Models\MessageManagementValue;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Cookie;

class MessageManagementProvider extends ServiceProvider
{
    public static function MessageManage(string $key){
        try{
            if(Cookie::get('language_select')){
                $language =Cookie::get('language_select');
            }else{
                $language='en';
            }
            $data=MessageManagementValue::where('key',$key)->where('language',$language)->first();
            if(!$data){
                $data=MessageManagement::where('key',$key)->first();
            }
            if($data){
                return $data->value;
            }
            return ;
        }catch(\Exception $e){
            return ;
        }
    }
}
