<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->integer('blog_category_id')->nullable()->comment('Blog Category Table(blog_categories) id');
            $table->bigInteger('default_language_page')->nullable();
            $table->text('post_title')->nullable();
            $table->longText('post_content')->nullable();
            $table->text('post_slug')->nullable();
            $table->string('post_type')->nullable();
            $table->enum('post_status',['Published','Draft','Trash'])->default('Published');
            $table->enum('media_type',['Image','Video'])->nullable();
            $table->string('image')->nullable();
            $table->enum('video_type',['MP4','Youtube'])->nullable();
            $table->string('video')->nullable();
            $table->longText('youtube')->nullable();
            $table->string('location')->nullable();
            $table->string('pdf')->nullable();
            $table->string('language')->default('en');
            $table->text('meta_key')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->bigInteger('total_post_view')->nullable();
            $table->integer('created_by')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->integer('updated_by')->nullable();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
};
