<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('financial_services', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('default_language_page')->nullable();
            $table->string('image_1')->nullable();
            $table->string('title_1')->nullable();
            $table->string('slug')->nullable();
            $table->string('sub_title')->nullable();
            $table->string('sub_sub_title')->nullable();
            $table->string('image_2')->nullable();
            $table->string('title_2')->nullable();
            $table->longText('description')->nullable();
            $table->string('title_3')->nullable();
            $table->string('button_text')->nullable();
            $table->text('button_link')->nullable();
            $table->string('language')->default('en');
            $table->string('meta_key')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('financial_services');
    }
};
