<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('go_online_create_websites', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('default_language_page')->nullable();
            $table->string('banner_image')->nullable();
            $table->string('title')->nullable();
            $table->string('slug')->nullable();
            $table->string('sub_title')->nullable();
            $table->longText('description')->nullable();
            $table->string('title_2')->nullable();
            $table->string('button_text')->nullable();
            $table->Text('button_link')->nullable();


            $table->enum('media_type',['Image','Video'])->nullable();
            $table->string('image')->nullable();
            $table->enum('video_type',['MP4','Youtube'])->nullable();
            $table->string('video')->nullable();
            $table->string('thumbnail_image')->nullable();
            $table->longText('youtube')->nullable();

            $table->Text('text_1')->nullable();
            $table->Text('text_2')->nullable();

            $table->string('language')->nullable();
            $table->string('meta_key')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('go_online_create_websites');
    }
};
