<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->integer('subscription_id')->index()->comment('subscription Table(subscriptions) id');
            $table->string('transaction_id')->nullable();
            $table->string('status')->nullable();
            $table->string('code')->nullable();
            $table->string('message')->nullable();
            $table->float('amount')->nullable();
            $table->string('currency')->nullable();
            $table->string('time')->nullable();
            $table->string('json_response')->nullable();
            $table->date('payment_date')->nullable()->default(DB::raw('CURRENT_DATE'));
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
