<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_us_global_offices_addresses', function (Blueprint $table) {
            $table->id();
            $table->integer('contact_us_id')->index()->comment('Table (contact_us) id');
            $table->integer('contact_us_global_office_id')->comment('Table(contact_us_global_office) id');
            $table->string('title')->nullable();
            $table->string('link')->nullable();
            $table->longText('description')->nullable();
            $table->longText('image')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_us_global_offices_addresses');
    }
};
