<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_details', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->unique();
            $table->string('no_of_employee')->nullable();
            $table->integer('industry')->nullable();
            $table->string('alternate_phone')->nullable();
            $table->string('alternate_calling_code')->nullable();
            $table->string('designation')->nullable();
            $table->string('billing_company_name')->nullable();
            $table->string('billing_country')->nullable();
            $table->string('billing_state')->nullable();
            $table->string('billing_city')->nullable();
            $table->string('billing_address')->nullable();
            $table->string('billing_pincode')->nullable();
            $table->string('billing_email')->nullable();
            $table->string('billing_calling_code')->nullable();
            $table->string('billing_phone')->nullable();
            $table->longText('bio')->nullable();
            $table->string('gst_number')->nullable();
            $table->string('pan_number')->nullable();
            $table->string('trn_number')->nullable();
            $table->string('acra_number')->nullable();
            $table->string('npwp_number')->nullable();
            $table->string('tax_registration_number')->nullable();
            $table->string('company_registration_number')->nullable();
            $table->string('acra_profile_copy')->nullable();
            $table->string('tax_registration_document')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_details');
    }
};
