<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_gateway_keys', function (Blueprint $table) {
            $table->id();
            $table->string('country_code')->nullable();
            $table->enum('payment_method',['auropay']);
            $table->string('apikey')->nullable();
            $table->string('accesskey')->nullable();
            $table->string('secretkey')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_gateway_keys');
    }
};
