<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partner_notifications', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->index();
            $table->enum('notification_from',['0','1','2','3'])->default('0')->comment('0->default, 1->customer, 2->account, 3->subscription');
            $table->integer('table_id')->nullable();
            $table->longText('notification')->nullable();
            $table->enum('status',['0','1'])->default('0')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partner_notifications');
    }
};
