<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partner_page_contents', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('sub_title')->nullable();
            $table->string('banner_image')->nullable();
            $table->longText('description')->nullable();
            $table->string('business_text')->nullable();
            $table->longText('business_description')->nullable();
            $table->string('marketing_text')->nullable();
            $table->longText('marketing_description')->nullable();
            $table->string('typical_benefits_text')->nullable();
            $table->longText('typical_benefits_description')->nullable();
            $table->string('partnership_documents_text')->nullable();
            $table->longText('partnership_documents_description')->nullable();
            $table->string('image')->nullable();

            $table->string('how_to_join_as_a_partner_text')->nullable();
            $table->longText('how_to_join_as_a_partner_description')->nullable();

            $table->string('page_2_image')->nullable();
            $table->string('page_3_image')->nullable();
            $table->string('page_4_image')->nullable();
            $table->string('page_5_image')->nullable();
            $table->string('page_6_image')->nullable();
            $table->string('page_7_image')->nullable();
            $table->string('kyc_form_text')->nullable();
            $table->string('kyc_form')->nullable();
            $table->string('view_terms_of_use_text')->nullable();
            $table->string('view_terms_of_use_link')->nullable();

            $table->string('status_reject_text')->nullable();
            $table->string('status_under_process_text')->nullable();
            $table->string('status_success_text')->nullable();

            $table->string('language')->default('en');
            $table->string('meta_key')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->enum('status', ['Published', 'Draft', 'Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partner_page_contents');
    }
};
