<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pricing_addones_prices', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('pricing_addon_id')->index()->comment('Addones Price (pricing_addons) Table ID');
            $table->string('plan_type')->nullable();
            $table->string('country_code')->nullable();
            $table->string('country_name')->nullable();
            $table->string('currency')->nullable();
            $table->float('monthly')->nullable();
            $table->float('quaterly')->nullable();
            $table->float('yearly')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pricing_addones_prices');
    }
};
