@php
$type_name=ucfirst($type);
$header_title="Aurobees | $type_name Management | Category";
$header_name = $type;
$page_name = $type.'_category';
@endphp
@extends('admin.admin_master')
@section('admin')
<script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?=@$type_name?> Category</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            @if($type=='post')
                                <li class="breadcrumb-item"><a href="{{route('post.list')}}"><?=@$type_name?></a></li>
                            @elseif($type=='news')
                                <li class="breadcrumb-item"><a href="{{route('latest-news.list')}}"><?=@$type_name?></a></li>
                            @endif
                            <li class="breadcrumb-item"><a href="{{route('user.blog.category.view',$type)}}">Category</a></li>
                            <li class="breadcrumb-item active">Edit Category</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit <?=@$type_name?> Category</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('user.blog.category.update',[$type,$data->id])}}" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="old_image" value="{{$data->image}}">
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="name" id="title" class="form-control"  value="{{$data->name}}" placeholder="Enter Name" required>
                                                @error('name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group slug-div">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="slug" id="slug" class="form-control" placeholder="Slug"  value="{{$data->slug}}" readonly>
                                                @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}" {{$value->id==$data->default_language_page?'selected':''}}>{{ $value->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group form-default">
                                                <label >Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control">{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" class="form-control" value="{{$data->meta_key}}" placeholder="Enter Meta Key" required>
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" class="form-control" value="{{$data->meta_title}}" placeholder="Enter Meta Title" required>
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="meta_description" class="form-control" placeholder="Enter Meta Description" required>{{$data->meta_description}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required  onchange="LanguageChangePage(this.value);">
                                                    @foreach($languages as $value)
                                                        @if($data->language=='en' && $value->code=='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @elseif ($data->language !='en' && $value->code !='en')
                                                            <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                        @endif
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input"  name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}">
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Update" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script>
       CKEDITOR.replace( 'description' );
    </script>
    <script>
        $(document).ready(function() {
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
        });

        //slug
        const post_title = document.querySelector('#title');
        post_title.addEventListener('keyup', function() {
            const inputString = $(this).val();
            const outputString = inputString.replace(/[^a-zA-Z0-9]/g, "-").replace(/\s+/g, "-");
            console.log(outputString);
            $('#slug').val(outputString);
        });
    </script>
    <script>
        $(document).ready(function() {
            @if($data->language=='en')
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
            @else
                $('.slug-div').hide();
                $('.select-language-page-div select').prop('required', true);
            @endif
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
                $('.slug-div').show();
                $('.slug-div input').prop('required', true);
            }else{
                $('.slug-div').hide();
                $('.slug-div input').prop('required', false);
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection
