@php
$header_title="Aurobees | Customer Management | Customer";
$header_name = 'customer_management';
$page_name = 'customer';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Customer</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.customer.view')}}">Customer Management</a></li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Customer</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('admin.customer.update',$data->id) }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Code</label>
                                                <input type="text" value="{{$data->code}}" class="form-control" disabled>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Partner Code</label>
                                                <input type="text" name="partner_code" value="{{$data->partner_code}}" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>First Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="f_name" id="f_name" value="{{$data->f_name}}" class="form-control" placeholder="Enter First Name" required>
                                                @error('f_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Last Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="l_name" id="l_name" value="{{$data->l_name}}" class="form-control" placeholder="Enter Last Name" required>
                                                @error('l_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Phone Number<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="number" name="phone" id='phone' value="{{$data->phone}}" class="form-control" placeholder="Enter Phone Number" required>
                                                @error('phone')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Email<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="email" name="email" id="email" value="{{$data->email}}" class="form-control" placeholder="Enter Email" required>
                                                @error('email')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="form-group">
                                                    <label>International Calling Code<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select  class="form-control custom-select select2" name="calling_code" id="calling_code" >
                                                        @foreach ($calling_code_list as $key=> $calling_code)
                                                             <option value="{{$calling_code->country_code}}" @if($data->calling_code && $data->calling_code ==$calling_code->country_code) selected @endif>{{$calling_code->name}}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('calling_code')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 customer_div">
                                            <div class="form-group">
                                                <label>Company Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="company" id="company" class="form-control" placeholder="Enter Company Name" value="{{$data->company}}" required>
                                                @error('company')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Country Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <select  class="form-control" name="country" id="country" required>
                                                   @foreach ($country_list as $country)
                                                        <option value="{{$country->code}}" @if(($data->country && $data->country ==$country->code) ||(!$data->country &&$country->code=='IN')) selected @endif >{{$country->name}}</option>
                                                   @endforeach
                                                </select>
                                                @error('country')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 statelist-div">
                                            <div class="form-group">
                                                <label>State Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <select  class="form-control custom-select " name="statelist" id="statelist" >
                                                   @foreach ($state_list as $state)
                                                        <option value="{{$state->code}}"  @if($data->state && $data->state ==$state->code) selected @endif>{{$state->name}}</option>
                                                   @endforeach
                                                </select>
                                                @error('statelist')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>City Name</label>
                                                <input type="text" name="city" id="city" class="form-control" placeholder="Enter City Name"  value="{{$data->city}}">
                                                @error('city')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Address</label>
                                                <input type="text" name="address" id="address" class="form-control"  value="{{$data->address}}" placeholder="Enter Address">
                                                @error('address')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6 pincode-div">
                                            <div class="form-group">
                                                <label>Pincode<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="pincode" id="pincode" class="form-control"  value="{{$data->pincode}}" placeholder="Enter Pincode"  >
                                                @error('pincode')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Update" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script>
        @if ($data->country=='IN')
            $('.statelist-div').show();
        @else
            $('.statelist-div').hide();
        @endif
        @if ($data->country=='AE')
            $('.pincode-div').hide();
        @else
            $('.pincode-div').show();
        @endif


        $('#country').change(function(){
            if($(this).val()=='IN'){
                $('.statelist-div').show();
            }else{
                $('.statelist-div').hide();
            }

            if($(this).val()=='AE'){
                $('.pincode-div').hide();
            }else{
                $('.pincode-div').show();
            }
        });

        //email
        jQuery(document).on('keypress', '#email', function(event) {
                var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key) && event.which !== 13) {
                    event.preventDefault();
                    return false;
                }
            });
            //Dealer Name
            jQuery(document).on('keypress', '#f_name,#l_name', function(event) {
                $(this).css({'text-transform': 'capitalize'});
                var regex = new RegExp("^[a-zA-Z ]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key) && event.which !== 13) {
                    event.preventDefault();
                    return false;
                }
            });
            //phone
            jQuery(document).on('keypress', '#phone', function(event) {
                var regex = new RegExp("^[0-9]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key) && event.which !== 13) {
                    event.preventDefault();
                    return false;
                }
                var phone_no=$('#phone').val();
                if(phone_no.length>10){
                    return false;
                }
            });
            //phone
            jQuery(document).on('keypress', '#pincode', function(event) {
                var regex = new RegExp("^[0-9]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key) && event.which !== 13) {
                    event.preventDefault();
                    return false;
                }
                
            });
            //Street  Address
            jQuery(document).on('keypress', '#address,#company,#state,#city', function(event) {
                $(this).css({'text-transform': 'capitalize'});
                var regex = new RegExp("^[a-zA-Z0-9 .' ,-]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key) && event.which !== 13) {
                    event.preventDefault();
                    return false;
                }
            });
        </script>
@endsection
