@php
    $header_title = 'Aurobees  | Billing';
    $header_name = 'lob_subscription_management';
    $page_name = 'lob_billing';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Billing</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Billing</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">All Billing</h3>
                            <div style="float: right"><a href="{{route('lob.billing.excel')}}" class="btn btn-primary btn-rounded">Download</a></div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body" style="overflow-x: scroll;">
                            <table id="daterange_table" class="table table-striped table-bordered table-sm " cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Partner Code</th>
                                        <th>Billing Number</th>
                                        <th>Company</th>
                                        <th>Name</th>
                                        <th>LOB Name</th>
                                        <th>LOB Type</th>
                                        <th>LOB Plan</th>
                                        <th>No. User</th>
                                        <th>Form Date</th>
                                        <th>Due Date</th>
                                        <th>Commission percentage</th>
                                        <th>Commission Amount</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Paid Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>

@endsection
@section('script')
    <script>
        $(function () {
            var table = $('#daterange_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('lob.billing.list') }}"
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },  // Row index (key + 1)
                    { data: 'partner_code', name: 'users.partner_code' },
                    { data: 'serial_number', name: 'subscriptions.serial_number' },
                    { data: 'company', name: 'users.company' },
                    { data: 'name', name: 'users.f_name' },
                    { data: 'industry_title', name: 'industries.title' },
                    { data: 'plan_name', name: 'subscriptions.plan_name' },
                    { data: 'plan_duration', name: 'subscriptions.plan_duration' },
                    { data: 'quantity', name: 'subscriptions.quantity' },

                    { data: 'start_at', name: 'subscriptions.start_at', render: function(data, type, row) {
                        return moment(data).format('H:mm:ss DD-MM-YYYY'); // Format start date with time
                    }},
                    { data: 'end_at', name: 'subscriptions.end_at', render: function(data, type, row) {
                        return moment(data).format('H:mm:ss DD-MM-YYYY'); // Format end date with time
                    }},
                    { data: 'partner_commission_percentage', name: 'subscriptions.partner_commission_percentage' }, // Leave status as it is
                    { data: 'partner_commission_amount', name: 'subscriptions.partner_commission_amount' }, // Leave country code as it is
                    { data: 'grand_amount', name: 'subscriptions.grand_amount', render: $.fn.dataTable.render.number(',', '.', 2) }, // Format as currency (grand total)

                    { data: 'status', name: 'status', orderable: false, searchable: false },  // Action buttons (Edit, Gallery, Delete)
                    { data: 'start_at', name: 'subscriptions.start_at', render: function(data, type, row) {
                        return moment(data).format('H:mm:ss DD-MM-YYYY'); // Format start date with time
                    }},
                    { data: 'action', name: 'action', orderable: false, searchable: false }  // Action buttons (Edit, Gallery, Delete)
                ]
            });
        });
    </script>
@endsection
