@php
    $header_title = 'Aurobees  | General Page Management | Contact Us';
    $header_name = 'general_management';
    $page_name = 'general_page_contact-us';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Contact Us</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('page.contact-us.list')}}">Contact Us</a></li>
                            <li class="breadcrumb-item active">Add</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Add Contact Us</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('page.contact-us.store') }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control" maxlength="20"
                                                    placeholder="Title" value="{{old('title')}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="slug" id="slug" class="form-control"
                                                    placeholder="Slug"  value="contact-us" readonly>
                                                @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Let's Connect Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="lets_connect_text" class="form-control" maxlength="20"
                                                    placeholder="Let's Connect Text"  value="{{old('lets_connect_text')}}" required>
                                                @error('lets_connect_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>First Name Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="first_name_text" class="form-control"
                                                    placeholder="First Name Text"  value="{{old('first_name_text')}}" required>
                                                @error('first_name_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Last Name Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="last_name_text" class="form-control"
                                                    placeholder="Last Name Text"  value="{{old('last_name_text')}}" required>
                                                @error('last_name_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Email Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="email_text" class="form-control"
                                                    placeholder="Email Text"  value="{{old('email_text')}}" required>
                                                @error('email_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Phone Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="phone_text" class="form-control"
                                                    placeholder="Phone Text"  value="{{old('phone_text')}}" required>
                                                @error('phone_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Corporate Headquarters Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="corporate_headquarters_text" class="form-control" maxlength="30"
                                                    placeholder="Corporate Headquarters Text"  value="{{old('corporate_headquarters_text')}}" required>
                                                @error('corporate_headquarters_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Link Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="link_text" class="form-control"  maxlength="35"
                                                    placeholder="Link Text"  value="{{old('link_text')}}" required>
                                                @error('link_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Link Url<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="url" name="link_link" class="form-control"
                                                    placeholder="Link Url"  value="{{old('link_link')}}" required>
                                                @error('link_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Address<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="address" placeholder="Address" id="address" class="form-control" required>{{old('address')}}</textarea>
                                                @error('address')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Global Offices Text<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="global_offices_text" class="form-control"  maxlength="20"
                                                    placeholder="Global Offices Text"  value="{{old('global_offices_text')}}" required>
                                                @error('global_offices_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{old('meta_key')}}" required>
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{old('meta_title')}}" required>
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="meta_description" placeholder="Meta Description" class="form-control" required>{{old('meta_description')}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" id="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}">{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group ">
                                                <label for="exampleInputFile">Banner Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="banner_image" id="header_icon" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 774 px</small>
                                                @error('banner_image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="header_icon_showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Map<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="map" id="map" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 773 × 351 px</small>
                                                @error('map')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="map_showImage" style="max-width: 150px;max-height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
<script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace( 'address', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
</script>
    <script>
        $(document).ready(function() {
            //image
            $('#header_icon').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#header_icon_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //image
            $('#map').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#map_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>

@endsection
