@php
    $header_title = 'Aurobees  | Event Page Management | Event';
    $header_name = 'general_page_event';
    $sub_header_name = 'general_page_event';
    $page_name = 'general_page_event_date';
@endphp
@extends('admin.admin_master')
@section('admin')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>All Events</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('page.event.list')}}">Event</a></li>
                        <li class="breadcrumb-item">All Events</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">All Events</h3>
                            <div style="float: right"><a href="{{route('page.event.event-date.addnew')}}" class="btn btn-primary btn-rounded">Add New</a></div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="daterange_table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Datetime</th>
                                        <th>Meeting ID</th>
                                        <th>Meeting Password</th>
                                        <th>Status</th>
                                        <th style="min-width:250px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
@section('script')
    <script>
        $(function () {
            var table = $('#daterange_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('page.event.event-date.list') }}"
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },  // Row index (key + 1)
                    { data: 'title', name: 'title' },  
                    { data: 'datetime', name: 'datetime' }, 
                    { data: 'zoom_id', name: 'zoom_id' }, 
                    { data: 'zoom_password', name: 'zoom_password' }, 
                    { data: 'status', name: 'status' },
                    { data: 'action', name: 'action', orderable: false, searchable: false }  // Action buttons (Edit, Gallery, Delete)
                ]
            });
        });
    </script>
@endsection