@php
    $header_title = 'Aurobees  | Event Page Management | Event';
    $header_name = 'general_page_event';
    $sub_header_name = 'general_page_event';
    $page_name = 'general_page_event_date';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Event Form Data</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Event Form Data Management</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">List Event Form Data</h3>
                                <div style="float: right"><a href="{{route('page.event.event-form-data.excel', $id)}}" class="btn btn-primary btn-rounded">Download</a></div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                
                                <table id="daterange_table" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Event Name</th>
                                            <th>Event Date</th>
                                            <th>User Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection

@section('script')
    <script>
        $(function () {
            var table = $('#daterange_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('page.event.event-form-data.list', $id) }}",
                    type: 'GET',  
                    data: function(d) {
                        d.event_child_id = {{$id}}; 
                    }
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },  // Row index (key + 1)
                    { data: 'title', name: 'event_dates.title' },  
                    { data: 'datetime', name: 'event_dates.datetime' }, 
                    { data: 'full_name', name: 'event_form_data.f_name' },
                    { data: 'email', name: 'event_form_data.email' },
                    { data: 'phone', name: 'event_form_data.phone' },
                ]
            });
        });
    </script>
@endsection