@php
    $header_title = 'Aurobees | Financial Service';
    $header_name = 'financial-service_management';
    $page_name = 'financial-service-business-payment-platforms';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Financial Service/Business Payment Platforms</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('financial-service.business-payment-platforms.list')}}">Business Payment Platforms</a></li>
                            <li class="breadcrumb-item active">Add</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Add Business Payment Platforms</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('financial-service.business-payment-platforms.store') }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title" id="title" class="form-control" placeholder="Title" maxlength="35" value="{{old('title')}}" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group slug-div">
                                                <label>Slug<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="slug" id="slug" class="form-control" placeholder="Slug"  value="{{old('slug')}}" required>
                                                @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            @if($defaultLanguagePagesList)
                                                <div class="form-group select-language-page-div">
                                                    <label>Select Page<span style="color:red;font-size: 120%;">*</span></label>
                                                    <select name="default_language_page" id="default_language_page" class="form-control">
                                                        @foreach ($defaultLanguagePagesList as $value)
                                                            <option value="{{ $value->id }}">{{ $value->title }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('default_language_page')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <label>Sub Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="sub_title" class="form-control" placeholder="Sub Title" maxlength="80" value="{{old('sub_title')}}" required>
                                                @error('sub_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" id="description" class="form-control" required>{{old('description')}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Key Benefits Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="key_benefits_title"  class="form-control" maxlength="15"
                                                    placeholder="Key Benefits Title"  value="{{old('key_benefits_title')}}" required>
                                                @error('key_benefits_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Key Benefits<span style="color:red;font-size: 120%;">*</span></label>
                                            </div>
                                            <div class="form-group">
                                                <input type="text" name="key_benefits_1" class="form-control" placeholder="Key Benefits" maxlength="40" value="{{old('key_benefits_1')}}" required>
                                                @error('key_benefits_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <input type="text" name="key_benefits_2" class="form-control" placeholder="Key Benefits" maxlength="40" value="{{old('key_benefits_2')}}" required>
                                                @error('key_benefits_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <input type="text" name="key_benefits_3" class="form-control" placeholder="Key Benefits" maxlength="40" value="{{old('key_benefits_3')}}" required>
                                                @error('key_benefits_3')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <input type="text" name="key_benefits_4" class="form-control" placeholder="Key Benefits" maxlength="40" value="{{old('key_benefits_4')}}" required>
                                                @error('key_benefits_4')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <input type="text" name="key_benefits_5" class="form-control" placeholder="Key Benefits" maxlength="40" value="{{old('key_benefits_5')}}" required>
                                                @error('key_benefits_5')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Text</label>
                                                <input type="text" name="button_text" class="form-control" placeholder="Button Text"  maxlength="15" value="{{old('button_text')}}" >
                                                @error('button_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Link</label>
                                                <input type="url" name="button_link" class="form-control" placeholder="Button Link"  value="{{old('button_link')}}" >
                                                @error('button_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key" class="form-control"
                                                    placeholder="Meta Key"  value="{{old('meta_key')}}" required>
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title" class="form-control"
                                                    placeholder="Meta Title"  value="{{old('meta_title')}}" required>
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span style="color:red;font-size: 120%;">*</span></label>
                                                <textarea name="meta_description" placeholder="Meta Description" class="form-control" required>{{old('meta_description')}}</textarea>
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" id="language" class="form-control" onchange="LanguageChangePage(this.value);" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}">{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group ">
                                                <label for="exampleInputFile">Image 1<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image_1" id="image_1" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 774 px</small>
                                                @error('image_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="image_1_showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                            <div class="form-group ">
                                                <label for="exampleInputFile">Image 2<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image_2" id="image_2" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1393 × 899 px</small>
                                                @error('image_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="image_2_showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>

        $(document).ready(function() {
            //image 1
            $('#image_1').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#image_1_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //image 2
            $('#image_2').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#image_2_showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
            //slug
            const post_title = document.querySelector('#title');
            post_title.addEventListener('keyup', function() {
                const inputString = $(this).val();
                const outputString = inputString.replace(/[^a-zA-Z0-9]/g, "-").replace(/\s+/g, "-");
                console.log(outputString);
                $('#slug').val(outputString);
            });
        });

    </script>
    <script>
        $(document).ready(function() {
            $('.select-language-page-div').hide();
            // $('.slug-div').hide();
        });
        function LanguageChangePage(value){
            if(value=='en'){
                $('.select-language-page-div').hide();
                $('.select-language-page-div select').prop('required', false);
                $('.slug-div').show();
                $('.slug-div input').prop('required', true);
            }else{
                $('.slug-div').hide();
                $('.slug-div input').prop('required', false);
                $('.select-language-page-div').show();
                $('.select-language-page-div select').prop('required', true);
            }
        }
    </script>
@endsection
