@php
    $header_title = 'Aurobees  | Home Page Management | Brands';
    $header_name = 'home_management';
    $sub_header_name='home_brands';
    $page_name = 'home_brands';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Brands</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.brands.list')}}">Brands</a></li>
                            <li class="breadcrumb-item active">Add Brands</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Add Brands</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('home.brands.store') }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Link</label>
                                                <input type="text" name="link"  class="form-control" placeholder="Link" value="{{old('link')}}">
                                                @error('link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="exampleInputFile">Logo<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="logo" id="image">
                                                        <label class="custom-file-label">Choose Logo</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 150 × 150 px</small>
                                                @error('logo')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });

        });
    </script>
@endsection

