@php
    $header_title = 'Aurobees  | Home Page Management | Integrated Supply';
    $header_name = 'home_management';
    $page_name = 'home_integrated-supply';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Integrated Supply</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.integrated-supply.list')}}">Integrated Supply</a></li>
                            <li class="breadcrumb-item active">Edit Integrated Supply</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Integrated Supply</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('home.integrated-supply.update',$data->id)}}" enctype="multipart/form-data">
                                    <input type="hidden" name="old_image" value="{{@$data->image}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Title 1<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title_1" id="title_1" class="form-control"
                                                    placeholder="Title" maxlength="25" value="{{$data->title_1}}" required>
                                                @error('title_1')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Title 2<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title_2" maxlength="35" id="title_2" class="form-control"
                                                    placeholder="Title" value="{{$data->title_2}}" required>
                                                @error('title_2')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Description<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="description" maxlength="140" id="description" class="form-control" required>{{$data->description}}</textarea>
                                                <span class="form-bar"></span>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Text</label>
                                                <input type="text" maxlength="25"  name="button_text" class="form-control"
                                                    placeholder="Button Text"  value="{{$data->button_text}}" >
                                                @error('button_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Button Link</label>
                                                <input type="url" name="button_link" class="form-control"
                                                    placeholder="Button Link"  value="{{$data->button_link}}" >
                                                @error('button_link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" class="form-control" required>
                                                    @foreach ($languages as $value)
                                                        <option value="{{ $value->code }}" {{$value->code==$data->language?'selected':''}}>{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            {{-- ---------------------------------------------------------------------------------------------- --}}

                                            <div class="form-group">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image">
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 808 × 747 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="width: 150px;height:150px;" src="{{(!empty($data->image))? url($data->image):url('image-placeholder.png')}}">
                                            </div>

                                            {{-- ------------------------------------------------------------------------------------------------- --}}
                                        </div>
                                    </div>
                                    <hr>
                                    <center>
                                        <input type="submit" value="Submit" class="btn btn-round btn-primary">
                                        <a href="{{route('home.integrated-supply.list')}}" class="btn btn-round btn-link">Back</a>
                                    </center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('description');
    </script>
    <script>
        $(document).ready(function() {
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>
@endsection

