@php
    $header_title = 'Aurobees  | Home Page Management | Our Services';
    $header_name = 'home_management';
    $sub_header_name='home_our-service';
    $page_name = 'home_our-services';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style>
        .select2-container .select2-selection--single {
            height: 37px !important;
        }
    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Our Services</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{route('home.our-services.list')}}">Our Services</a></li>
                            <li class="breadcrumb-item active">View Our Services</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">View Our Services</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <th>Title</th>
                                        <td>{{$data->title}}</td>
                                   </tr>
                                    <tr>
                                        <th>Button Text</th>
                                        <td>{{$data->button_text}}</td>
                                   </tr>
                                    <tr>
                                        <th>Button Link</th>
                                        <td>{{$data->button_link}}</td>
                                   </tr>
                                    <tr>
                                        <th>Description</th>
                                        <td><?=$data->description?></td>
                                   </tr>
                                   <tr>
                                        <th>Image 1</th>
                                        <td><img class="rounded-circle" style="max-width: 300px;max-height: 300px" src="{{(!empty($data->image_1))? url($data->image_1):url('image-placeholder.png')}}"></td>
                                    </tr>
                                   <tr>
                                        <th>Image 2</th>
                                        <td><img class="rounded-circle" style="max-width: 300px;" src="{{(!empty($data->image_2))? url($data->image_2):url('image-placeholder.png')}}"></td>
                                    </tr>
                                   <tr>
                                        <th>Language</th>
                                        <td>{{$data['Language']['name']}}</td>
                                   </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>{{$data->status}}</td>
                                    </tr>
                                </tbody>
                            </table>
                            <hr>
                            <center><a href="{{route('home.our-services.list')}}" class="btn btn-round btn-primary">Back</a></center>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
