@php
    $header_title = 'Aurobees | Pricing Management';
    $header_name = 'industries_management';
    $page_name = 'pricing';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style> .select2-container .select2-selection--single { height: 37px !important;  }    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Pricing</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('pricing.index') }}">Manage Pricing</a></li>
                            <li class="breadcrumb-item">Add Pricing</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Add New</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('pricing.store') }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Lob<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="lob_id" id="category" class="form-control" required>
                                                    <option data-lang="" value="">Please select...</option>
                                                    @foreach ($industries as $key => $data)
                                                        <option data-lang="{{ $data->language }}" value="{{ $data->id }}">{{ $data->title }}</option>
                                                    @endforeach
                                                </select>
                                                @error('lob_id')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="language" id="language" class="form-control"  onchange="LanguageChangePage(this.value);" required>
                                                    <option value="">Select</option>
                                                    @foreach ($languages as $key => $value)
                                                        <option value="{{ $value->code }}">{{ $value->name }}</option>
                                                    @endforeach;
                                                </select>
                                                @error('language')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row plan-pricing-div">
                                        <div class="col-md-12">
                                            <div class="row">
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Plan Type</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Country</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>Currency</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>Monthly</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Quaterly</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Yearly</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label title="Only Applied for Ecommerce Plan">Min. order<span style="color:red;font-size: 120%;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>Action</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="price_div">
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="form-group">
                                                            <select name="plan_type[]" class="form-control select2">
                                                                <option value="Free-Trial">Free Trial</option>
                                                                <option value="Basic">Basic</option>
                                                                <option value="Advance">Advance</option>
                                                                <option value="Ecommerce">Ecommerce</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="form-group">
                                                            <select name="country[]" class="form-control select2">
                                                                @foreach ($country_list as $country)
                                                                    <option value="{{$country->code.'#'.$country->name}}">{{$country->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <select name="currency[]" class="form-control select2">
                                                                @foreach ($currency_list as $currency)
                                                                    <option value="{{$currency->code}}">{{$currency->code}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <input type="text" name="monthly[]" class="form-control input-float">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="form-group">
                                                            <input type="text" name="quaterly[]" class="form-control input-float">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="form-group">
                                                            <input type="text" name="yearly[]" class="form-control input-float">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <input type="text" name="no_of_order[]" class="form-control input-number" required min="1" value="1">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <a href="javascript:void(0)" onclick="AddNewRow();"><i class="fa fa-plus-circle" style="font-size:30px;color:green"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group form-default">
                                                <label>Content<span style="color:red;font-size: 120%;">*</span> </label>
                                                <textarea name="content" id="content" class="form-control">{{ old('content') }}</textarea>
                                                <span class="form-bar"></span>
                                                @error('content')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>Free Trial Text</label>
                                                <input type="text" name="free_trial_text"  class="form-control" placeholder="Free Trial Text" value="{{ old('free_trial_text') }}">
                                                @error('free_trial_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Free Trial Content</label>
                                                <textarea name="free_trial_content" id="free_trial_content" class="form-control">{{ old('free_trial_content') }}</textarea>
                                                <span class="form-bar"></span>
                                                @error('free_trial_content')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Basic Text</label>
                                                <input type="text" name="basic_text"  class="form-control" placeholder="Basic Text" value="{{ old('basic_text') }}">
                                                @error('basic_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Basic Recommended</label>
                                                <input type="checkbox" name="basic_recommended" >
                                                @error('basic_recommended')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Basic Content</label>
                                                <textarea name="basic_content" id="basic_content" class="form-control">{{ old('basic_content') }}</textarea>
                                                <span class="form-bar"></span>
                                                @error('basic_content')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Advance Text</label>
                                                <input type="text" name="advance_text"  class="form-control" placeholder="Advance Text" value="{{ old('advance_text') }}">
                                                @error('advance_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Advance Recommended</label>
                                                <input type="checkbox" name="advance_recommended" >
                                                @error('advance_recommended')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>Advance Content</label>
                                                <textarea name="advance_content" id="advance_content" class="form-control">{{ old('advance_content') }}</textarea>
                                                <span class="form-bar"></span>
                                                @error('advance_content')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>GO-Ecommerce Text</label>
                                                <input type="text" name="ecom_text"  class="form-control" placeholder="GO-Ecommerce Text" value="{{ old('ecom_text') }}">
                                                @error('ecom_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>GO-Ecommerce Recommended</label>
                                                <input type="checkbox" name="ecom_recommended" >
                                                @error('ecom_recommended')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group form-default">
                                                <label>GO-Ecommerce Content</label>
                                                <textarea name="ecom_content" id="ecom_content" class="form-control">{{ old('ecom_content') }}</textarea>
                                                <span class="form-bar"></span>
                                                @error('ecom_content')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <label>GO-Ecommerce Minimum Order Text</label>
                                                <input type="text" name="ecom_minimum_order_text"  class="form-control" placeholder="GO-Ecommerce Minimum Order Text"
                                                    value="{{ old('ecom_minimum_order_text') }}">
                                                @error('ecom_minimum_order_text')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Key<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_key" id="meta_key"
                                                    class="form-control" placeholder="Meta Key"
                                                    value="{{ old('meta_key') }}">
                                                @error('meta_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_title" id="meta_title"
                                                    class="form-control" placeholder="Meta Title"
                                                    value="{{ old('meta_title') }}">
                                                @error('meta_title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <label>Meta Description<span
                                                        style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="meta_description" id="meta_description"
                                                    class="form-control" placeholder="Meta Description"
                                                    value="{{ old('meta_description') }}">
                                                @error('meta_description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="exampleInputFile">Short Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="short_name" class="form-control" required>
                                                    <option value="MF" >MF</option>
                                                    <option value="FF" >FF</option>
                                                    <option value="TR" >TR</option>
                                                    <option value="Ecom" >Ecom</option>
                                                    <option value="TD" >TD</option>
                                                    <option value="WH" >WH</option>
                                                    <option value="DR" >DR</option>
                                                </select>
                                                @error('short_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            {{-- ----------------------- --}}
                                            <div class="form-group">
                                                <label for="exampleInputFile">Image<span style="color:red;font-size: 120%;">*</span></label>
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" name="image" id="image" required>
                                                        <label class="custom-file-label">Choose Image</label>
                                                    </div>
                                                </div>
                                                <small style="color:red;">Image Size should be 1920 × 788 px</small>
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="form-group">
                                                <img class="rounded-circle" id="showImage" style="max-width: 150px;max-height:150px;" src="{{ url('image-placeholder.png') }}">
                                            </div>
                                            {{-- ----------------------- --}}
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Submit" class="btn btn-round btn-primary">
                                    </center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script src="https://cdn.ckeditor.com/4.19.1/standard/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'content', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
        CKEDITOR.replace('free_trial_content', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
        CKEDITOR.replace('basic_content', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
        CKEDITOR.replace('advance_content', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
        CKEDITOR.replace('ecom_content', { format_tags: 'p;h1;h2;h3;h4;h5;h6;pre;address;div'});
    </script>
    <script>
        $(document).ready(function() {
            jQuery(document).on('keypress', '.input-float', function(event) {
                var regex = new RegExp("^[0-9.]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key)) {
                    event.preventDefault();
                    return false;
                }
            });
            jQuery(document).on('keypress', '.input-number', function(event) {
                var regex = new RegExp("^[0-9]+$");
                var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                if (!regex.test(key)) {
                    event.preventDefault();
                    return false;
                }
            });
            // $('#language').change(function() {
            //     var filter_lang = $(this).val();
            //     $('#category').val('');
            //     $('#category option').each(function() {
            //         if ($(this).data('lang') == filter_lang) {
            //             $(this).show();
            //         } else {
            //             $(this).hide();
            //         }
            //     });
            // });
            //image
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });

        function AddNewRow(){
            var data=`<div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <select name="plan_type[]" class="form-control select2">
                                <option value="Free-Trial">Free Trial</option>
                                <option value="Basic">Basic</option>
                                <option value="Advance">Advance</option>
                                <option value="Ecommerce">Ecommerce</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <select name="country[]" class="form-control select2">
                                @foreach ($country_list as $country)
                                    <option value="{{$country->code.'#'.$country->name}}">{{$country->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <select name="currency[]" class="form-control select2">
                                @foreach ($currency_list as $currency)
                                    <option value="{{$currency->code}}">{{$currency->code}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <input type="text" name="monthly[]" class="form-control input-float">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="text" name="quaterly[]" class="form-control input-float">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="text" name="yearly[]" class="form-control input-float">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <input type="text" name="no_of_order[]" class="form-control input-number" required min="1" value="1">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <a href="javascript:void(0)" onclick="$(this).closest('.row').remove();"><i class="fa fa-times-circle" style="font-size:30px;color:red"></i></a>
                        </div>
                    </div>
                </div>`;
            $('#price_div').append(data);
            $('.select2').select2();
        }
    </script>
    <script>
        function LanguageChangePage(value){
            if(value=='en'){
                $('.plan-pricing-div').show();
            }else{
                $('.plan-pricing-div').hide();
            }
        }
    </script>
@endsection
