@php
    $header_title = 'Aurobees | Pricing Management';
    $header_name = 'industries_management';
    $page_name = 'pricing';
@endphp
@extends('admin.admin_master')
@section('admin')
    <style> .select2-container .select2-selection--single { height: 37px !important;  }    </style>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Pricing</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('pricing.index') }}">Manage Pricing</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('pricing.feature',$parent->pricing_id) }}">Feature</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('pricing.addons',$parent->id) }}">Addons</a></li>
                            <li class="breadcrumb-item active">Edit Addons</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">{{$parent->name}} </h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{route('pricing.addons.update',[$feature_id,$id])}}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="form-group">
                                                <label>Name<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="name" value="{{$data->name}}" class="form-control" placeholder="Name"  required>
                                                @error('name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" @if($data->free_trial) checked @endif name="free_trial" id="free_trial">
                                                            <label class="form-check-label" for="free_trial">Free Trial</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-3">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" @if($data->basic) checked @endif name="basic" id="basic">
                                                            <label class="form-check-label" for="basic">Basic</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-3">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" @if($data->advance) checked @endif name="advance" id="advance">
                                                            <label class="form-check-label" for="advance">Advance</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-3">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" @if($data->go_ecommerce) checked @endif name="go_ecommerce" id="go_ecommerce">
                                                            <label class="form-check-label" for="go_ecommerce">Go Ecommerce</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Language</label>
                                                <input type="text" value="{{$parent['Pricing']['Language']['name']}}" class="form-control"  readonly>
                                            </div>
                                            <div class="form-group">
                                                <label>Status<span style="color:red;font-size: 120%;">*</span></label>
                                                <select name="status" class="form-control" required>
                                                    <option value="Published" {{$data->status=='Published'?'selected':''}} >Published</option>
                                                    <option value="Draft" {{$data->status=='Draft'?'selected':''}} >Draft</option>
                                                    <option value="Trash" {{$data->status=='Trash'?'selected':''}} >Trash</option>
                                                </select>
                                                @error('status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    {{-- price add --}}
                                    <div class="row plan-pricing-div">
                                        <div class="col-md-12">
                                            <div class="row">
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Plan Type<span style="color:red;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Country<span style="color:red;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>Currency<span style="color:red;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>Monthly<span style="color:red;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Quaterly<span style="color:red;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Yearly<span style="color:red;">*</span></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>Action</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="price_div">
                                               @if(!$pricingAddonsList->isEmpty())
                                                    @foreach ($pricingAddonsList as $item)
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="form-group">
                                                                    <select name="plan_type[]" class="form-control" required>
                                                                        <option value="Basic" @if($item->plan_type=='Basic') selected @endif >Basic</option>
                                                                        <option value="Advance" @if($item->plan_type=='Advance') selected @endif >Advance</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group">
                                                                    <select name="country[]" class="form-control select2">
                                                                        @foreach ($country_list as $country)
                                                                            <option value="{{$country->code.'#'.$country->name}}" @if($item->country_code==$country->code) selected @endif >{{$country->name}}</option>
                                                                        @endforeach   
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-1">
                                                                <div class="form-group">
                                                                    <select name="currency[]" class="form-control select2">
                                                                        @foreach ($currency_list as $currency)
                                                                            <option value="{{$currency->code}}" @if($item->currency==$currency->code) selected @endif >{{$currency->code}}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-1">
                                                                <div class="form-group">
                                                                    <input type="text" name="monthly[]" value="{{$item->monthly}}" class="form-control input-float" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group">
                                                                    <input type="text" name="quaterly[]" value="{{$item->quaterly}}" class="form-control input-float" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="form-group">
                                                                    <input type="text" name="yearly[]" value="{{$item->yearly}}" class="form-control input-float" required>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-1">
                                                                <div class="form-group">
                                                                    <a href="javascript:void(0)" onclick="$(this).closest('.row').remove();"><i class="fa fa-times-circle" style="font-size:30px;color:red"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                               @endif
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="form-group">
                                                        <a href="javascript:void(0)" class="btn btn-success" onclick="AddNewRow();"></i> Add Price</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <center>
                                        <a href="{{ route('pricing.addons',$parent->id) }}" class="btn btn-link btn-rounded">Back</a>
                                        <input type="submit" value="Submit" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function() {
        jQuery(document).on('keypress', '.input-float', function(event) {
            var regex = new RegExp("^[0-9.]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
        jQuery(document).on('keypress', '.input-number', function(event) {
            var regex = new RegExp("^[0-9]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
    });

    function AddNewRow(){
        var data=`<div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <select name="plan_type[]" class="form-control" required>
                            <option value="Basic">Basic</option>
                            <option value="Advance">Advance</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <select name="country[]" class="form-control select2">
                            @foreach ($country_list as $country)
                                <option value="{{$country->code.'#'.$country->name}}">{{$country->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-1">
                    <div class="form-group">
                        <select name="currency[]" class="form-control select2">
                            @foreach ($currency_list as $currency)
                                <option value="{{$currency->code}}">{{$currency->code}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-1">
                    <div class="form-group">
                        <input type="text" name="monthly[]" class="form-control input-float" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <input type="text" name="quaterly[]" class="form-control input-float" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <input type="text" name="yearly[]" class="form-control input-float" required>
                    </div>
                </div>
                <div class="col-md-1">
                    <div class="form-group">
                        <a href="javascript:void(0)" onclick="$(this).closest('.row').remove();"><i class="fa fa-times-circle" style="font-size:30px;color:red"></i></a>
                    </div>
                </div>
            </div>`;
        $('#price_div').append(data);
        $('.select2').select2();
    }
</script>
@endsection