@php
    $header_title = 'Aurobees  | Setting | Footer Management';
    $header_name = 'setting_management';
    $page_name = 'setting_header';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Footer Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Setting</a></li>
                        <li class="breadcrumb-item active">Footer Management</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Footer {{$parentMenu->title}} Menu</h3>
                            <div style="float: right">
                                <a href="{{route('setting.footer.footer-menu')}}" class="btn btn-link">Back</a>
                                <a href="{{route('setting.footer.footer-menu-child-add',$parentMenu->id)}}" class="btn btn-primary btn-rounded">Add New</a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>link</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="blog_category_body">
                                    @foreach ($datas as $key => $data)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $data->title }}</td>
                                            <td>{{ $data->link }}</td>
                                            <td>
                                                @if($key!=0)<a href="{{ route('setting.footer.footer-menu-child-pre',[$data->footer_menu_id,$data->order]) }}" class="btn btn-outline-info"><i class="fa fa-arrow-up"></i></a>@endif
                                                <a href="{{ route('setting.footer.footer-menu-child-next',[$data->footer_menu_id,$data->order]) }}" class="btn btn-outline-info"><i class="fa fa-arrow-down"></i></a>
                                                <a href="{{ route('setting.footer.footer-menu-child-edit',[$data->footer_menu_id,$data->id]) }}" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                                                <a href="{{ route('setting.footer.footer-menu-child.delete',$data->id) }}" onclick="return confirm('Are you sure you want to delete this menu?');" class="btn btn-outline-danger"  title="Permanently delete"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
