@php
    $header_title = 'Aurobees  | Setting | Forgot Password Management';
    $header_name = 'setting_management';
    $page_name = 'setting_forgot-password';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Forgot Password Page Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Setting</a></li>
                        <li class="breadcrumb-item active">Forgot Password Page Management</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Edit Forgot Password Page</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form  action ="{{route('setting.forgot-password.update')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Forgot Password Page</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="forgot_password_thumbnail_image" >
                                                    <label class="custom-file-label">Choose Thumbnail Image</label>
                                                </div>
                                            </div>
                                            <small style="color:red;">Image Size should be 990 × 600 px</small>
                                            @error('forgot_password_thumbnail_image')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            @php $forgot_password_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('forgot_password_thumbnail_image'); @endphp
                                            @if($forgot_password_thumbnail_image)
                                                <br>
                                                <a href="{{url($forgot_password_thumbnail_image)}}" target="_blank">View</a>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="forgot_password_video" >
                                                    <label class="custom-file-label">Choose Video</label>
                                                </div>
                                            </div>
                                            @error('forgot_password_video')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            @php $forgot_password_video = HelperServiceProvider::ForgotPasswordPageManagement('forgot_password_video'); @endphp
                                            @if($forgot_password_video)
                                                <br>
                                                <a href="{{url($forgot_password_video)}}" target="_blank">View</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Otp Page</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="otp_thumbnail_image" >
                                                    <label class="custom-file-label">Choose Thumbnail Image</label>
                                                </div>
                                            </div>
                                            <small style="color:red;">Image Size should be 990 × 600 px</small>
                                            @error('otp_thumbnail_image')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            @php $otp_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('otp_thumbnail_image'); @endphp
                                            @if($otp_thumbnail_image)
                                                <br>
                                                <a href="{{url($otp_thumbnail_image)}}" target="_blank">View</a>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="otp_video" >
                                                    <label class="custom-file-label">Choose Video</label>
                                                </div>
                                            </div>
                                            @error('otp_video')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            @php $otp_video = HelperServiceProvider::ForgotPasswordPageManagement('otp_video'); @endphp
                                            @if($otp_video)
                                                <br>
                                                <a href="{{url($otp_video)}}" target="_blank">View</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Change Password Page</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="change_password_thumbnail_image" >
                                                    <label class="custom-file-label">Choose Thumbnail Image</label>
                                                </div>
                                            </div>
                                            <small style="color:red;">Image Size should be 990 × 600 px</small>
                                            @error('change_password_thumbnail_image')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            @php $change_password_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('change_password_thumbnail_image'); @endphp
                                            @if($change_password_thumbnail_image)
                                                <br>
                                                <a href="{{url($change_password_thumbnail_image)}}" target="_blank">View</a>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="change_password_video" >
                                                    <label class="custom-file-label">Choose Video</label>
                                                </div>
                                            </div>
                                            @error('change_password_video')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            @php $change_password_video = HelperServiceProvider::ForgotPasswordPageManagement('change_password_video'); @endphp
                                            @if($change_password_video)
                                                <br>
                                                <a href="{{url($change_password_video)}}" target="_blank">View</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <center><input type="submit" class="btn btn-success" value="Update"></center>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
@section('script')
<script>
    // //image
    // $('#header_logo_1').change(function(e) {
    //     var reader = new FileReader();
    //     reader.onload = function(e) {
    //         $('#header_logo_11').attr('src', e.target.result);
    //     }
    //     reader.readAsDataURL(e.target.files['0']);
    // });
    // //image
    // $('#header_logo_2').change(function(e) {
    //     var reader = new FileReader();
    //     reader.onload = function(e) {
    //         $('#header_logo_22').attr('src', e.target.result);
    //     }
    //     reader.readAsDataURL(e.target.files['0']);
    // });

</script>
@endsection
