@php
    $header_title = 'Aurobees  | Setting | Header Management';
    $header_name = 'setting_management';
    $page_name = 'setting_header';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Header Menu</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Header Menu Edit</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Edit Header Menu</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <form method="POST" autocomplete="off" action="{{ route('setting.header.header-menu.edit',$data->id) }}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{$data->key}} Title<span style="color:red;font-size: 120%;">*</span></label>
                                                <input type="text" name="title"  value="{{$data->title}}" class="form-control" placeholder="Enter Title" required>
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Link</label>
                                                <input type="text" name="link" value="{{$data->link}}" class="form-control" placeholder="Enter Link">
                                                @error('link')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6"><label>Title<span style="color:red;">*</span></label></div>
                                        <div class="col-md-4"><label>Language<span style="color:red;">*</span></label></div>
                                        <div class="col-md-2"><label>Action</label></div>
                                    </div>
                                    <div class="add-language-row">
                                        @if (!$languageTitles->isEmpty())
                                        @foreach($languageTitles as $item)
                                            <div class="row main-row">
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <input type="text" name="language_title[]" value="{{$item->title}}" class="form-control" placeholder="Title" required>
                                                    </div>
                                                </div>
                                                <div class="col-4">
                                                    <div class="form-group">
                                                        <select class="form-control" required name="language[]">
                                                            @foreach ($languages as $value)
                                                                @if($value->code!='en')
                                                                    <option value="{{ $value->code }}" {{($value->code==$item->language)?'selected':''}}>{{ $value->name }}</option>
                                                                @endif
                                                            @endforeach;
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-2">
                                                    <center><button class="btn btn-danger" onclick="$(this).closest('.main-row').remove();">Delete</button></center>
                                                </div>
                                            </div>
                                        @endforeach
                                        @endif
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-round btn-link" onclick="AddRow()">Add Row</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <center><input type="submit" value="Update" class="btn btn-round btn-primary"></center>
                                </form>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
@section('script')
    <script>
        function AddRow(){
            data=`<div class="row main-row">
                <div class="col-6">
                    <div class="form-group">
                        <input type="text" name="language_title[]" class="form-control" placeholder="Title" required>
                    </div>
                </div>
                <div class="col-4">
                    <div class="form-group">
                        <select class="form-control" required name="language[]">
                            @foreach ($languages as $value)
                                @if($value->code!='en')
                                    <option value="{{ $value->code }}" >{{ $value->name }}</option>
                                @endif
                            @endforeach;
                        </select>
                    </div>
                </div>
                <div class="col-2">
                    <center><button class="btn btn-danger" onclick="$(this).closest('.main-row').remove();">Delete</button></center>
                </div>
            </div>`;
            $('.add-language-row').append(data);
        }
    </script>
@endsection
