@php
    $header_title = 'Aurobees  | Setting | Header Management';
    $header_name = 'setting_management';
    $page_name = 'setting_header';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Header Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Setting</a></li>
                        <li class="breadcrumb-item active">Header Management</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Header Menu</h3>
                            <div style="float: right;">
                                <a href="{{route('setting.header.list')}}" class="btn btn-link">Back</a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Key</th>
                                        <th>Title</th>
                                        <th>link</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="blog_category_body">
                                    @foreach ($datas as $key => $data)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $data->key }}</td>
                                            <td>{{ $data->title }}</td>
                                            <td>{{ $data->link }}</td>
                                            <td>
                                                @if($key!=0)<a href="{{ route('setting.header.header-menu-pre',$data->order) }}" class="btn btn-outline-info"><i class="fa fa-arrow-up"></i></a>@endif
                                                @if($key!=4)<a href="{{ route('setting.header.header-menu-next',$data->order) }}" class="btn btn-outline-info"><i class="fa fa-arrow-down"></i></a>@endif
                                                <a href="{{ route('setting.header.header-menu-edit',$data->id) }}" class="btn btn-outline-info"><i class="fas fa-edit"></i></a>
                                                @if($key!=4)<a href="{{ route('setting.header.header-menu-child',$data->id) }}" class="btn btn-outline-info">Sub Menu</a>@endif

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
