@php
    $header_title = 'Aurobees  | Setting | Menu Management';
    $header_name = 'setting_management';
    $page_name = 'setting_header';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Menu Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Setting</a></li>
                        <li class="breadcrumb-item active">Menu Management</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Edit Menu</h3>
                            <div style="float: right">
                                <a href="{{route('setting.top-header-menu')}}" class="btn btn-primary btn-rounded">Top Header Menu</a>
                                <a href="{{route('setting.header.header-menu')}}" class="btn btn-primary btn-rounded">Header Menu</a>
                                <a href="{{route('setting.footer.footer-menu')}}" class="btn btn-primary btn-rounded">Footer Menu</a>
                                <a href="{{route('setting.header.footer-social-icons')}}" class="btn btn-primary btn-rounded">Footer Social Icons</a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form  action ="{{route('setting.header.header-logo.store')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Header Logo 1<span style="color:red;">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="header_logo_1" id="header_logo_1" >
                                                    <label class="custom-file-label">Choose Image</label>
                                                </div>
                                            </div>
                                            <small style="color:red;">Image Size should be 299 × 69 px</small>
                                            @error('header_logo_1')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <img class="" id="header_logo_11" style="max-height:150px;" src="{{(!empty($header_logo_1->value))? url($header_logo_1->value):url('image-placeholder.png')}}">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Header Logo 2<span style="color:red;">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" name="header_logo_2" id="header_logo_2" >
                                                    <label class="custom-file-label">Choose Image</label>
                                                </div>
                                            </div>
                                            <small style="color:red;">Image Size should be 299 × 69 px</small>
                                            @error('header_logo_1')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <img class="" id="header_logo_22" style="max-height:150px;" src="{{(!empty($header_logo_2->value))? url($header_logo_2->value):url('image-placeholder.png')}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Footer Copyright Text<span style="color:red;">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-8">
                                        <div class="form-group">
                                            <input type="text"   value="{{HeaderManagementProvider::HeaderManage('copyright_text')}}" name="copyright_text" class="form-control" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <center><input type="submit" class="btn btn-success" value="Update"></center>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
@section('script')
<script>
    //image
    $('#header_logo_1').change(function(e) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#header_logo_11').attr('src', e.target.result);
        }
        reader.readAsDataURL(e.target.files['0']);
    });
    //image
    $('#header_logo_2').change(function(e) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#header_logo_22').attr('src', e.target.result);
        }
        reader.readAsDataURL(e.target.files['0']);
    });

</script>
@endsection
