@php
$meta_title = 'Aurobees | Dashboard';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='dashboard';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<style>
    .partner-h p{
        background-color: #35A8A2;
        color: #fff;
        border-radius: 10px;
        font-size: 20px;
        padding: 15px 15px;
        font-weight: 700;
        display: block;
        width: 100%;
    }

    .d-flex.aline_content.partner-h{
        flex-wrap: wrap;
    }

    .graph_dropdown {
        margin-bottom: 20px;
        width: 100%;
        max-width: 100%;
    }
</style>
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Dashboard</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    @include('frontend.become_a_partner.includes.body.sidebar')
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right n-dash-right">
                            {{-- box --}}
                            <div class="Subscribed_box">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Active Customer</h4>
                                            <div class="box_middle0">
                                                <p><a href="{{route('partner.customer.list')}}">{{$totalCustomer}}</a></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">  
                                        <div class="Subscribed_box_inner">
                                            <h4>New LOB Subscription this Week</h4>
                                            <div class="box_middle0">
                                                <p><a href="{{route('partner.billing.list')}}?duration=week">{{$currentWeekNewLOB}}</a></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Total Revenue Of Current Month</h4>
                                            <div class="box_middle01">
                                                <p>{{$amountCurrencyCode}} {{number_format($grand_amount_sum, 2)}}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="Subscribed_box_inner">
                                            <h4>Total Revenue share this month</h4>
                                            <div class="box_middle01">
                                                <p>{{$amountCurrencyCode}} {{number_format($partner_commission_sum, 2)}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                
                                @if($lobWiseRevenue)
                                    {{-- LOB wise Revenue of currrent Month --}}
                                    <div class="col-6">
                                        <div class="active_user">
                                            <div class="d-flex aline_content partner-h">
                                                <p class="title_user"><strong>LOB wise Revenue of current Month</strong></p>
                                            </div>
                                            <div class="active_user_graph">
                                                <canvas id="pie-chart-lob-total-revenue"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                    {{-- LOB wise Revenue Share of currrent Month --}}
                                    <div class="col-6">
                                        <div class="active_user">
                                            <div class="d-flex aline_content partner-h">
                                                <p class="title_user"><strong>LOB wise Revenue Share of current Month</strong></p>
                                            </div>
                                            <div class="active_user_graph">
                                                <canvas id="pie-chart-lob-share-revenue"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                {{-- subscription 12 months --}}
                                @if($revenueGenerated12Months)
                                    <div class="col-6">
                                        <div class="active_user">
                                            <div class="d-flex aline_content partner-h">
                                                <p class="title_user"><strong>12 month revenue generated trend</strong></p>
                                                
                                                @if($revenueGenerated12Months)
                                                    <div class="graph_dropdown">
                                                        <select id="" onchange="revenueGeneratedMonthBarChart(this.value);">
                                                            @foreach ($revenueGenerated12Months as $key=> $lob)
                                                            <option value="{{$key+1}}">{{$lob['name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="active_user_graph">
                                                <canvas id="subscription-12-months-revenue"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                {{-- Lob wise Customer --}}
                                @if($revenueGenerated12Months)
                                    <div class="col-6">
                                        <div class="active_user">
                                            <div class="d-flex aline_content partner-h">
                                                <p class="title_user"><strong>LOB wise Customer</strong></p>
                                                
                                                @if($revenueGenerated12Months)
                                                    <div class="graph_dropdown">
                                                        <select id="" onchange="activeUserMonthBarChart(this.value);">
                                                            @foreach ($revenueGenerated12Months as $key=> $lob)
                                                            <option value="{{$key+1}}">{{$lob['name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="active_user_graph">
                                                <canvas id="subscription-12-months-active-user"></canvas>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                
                                {{-- Lob wise Customer E-commerce --}}
                                @if($lobWiseSubscriptionEcommerce)
                                    <div class="col-6">
                                        <div class="active_user">
                                            <div class="d-flex aline_content partner-h">
                                                <p class="title_user"><strong>LOB wise Customer E-commerce</strong></p>
                                            </div>
                                            <div class="active_user_graph">
                                                <canvas id="bar-chart-lob-e-commerce" ></canvas>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('frontend.become_a_partner.includes.body.help-center-mobile')
        </div>
    </section>
</div>
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    
    @if($lobWiseRevenue)
        const revenueLabels = @json(collect($lobWiseRevenue)->pluck('name'));
        const totalRevenue = @json(collect($lobWiseRevenue)->pluck('total'));
        const partnerRevenue = @json(collect($lobWiseRevenue)->pluck('partner'));
        //pie cart LOBwise Revenue total of currrent Month
        new Chart(document.getElementById("pie-chart-lob-total-revenue"), {
            type: "pie", 
            data: {
                labels: revenueLabels,
                datasets: [{
                    data: totalRevenue,
                    backgroundColor: [
                        '#38a7a3',  
                        '#da9138',  
                        '#dc3545',
                        '#716aad', 
                        '#4BC0C0',  
                        '#8C8C',
                        '#f3e9cb'
                    ],
                    borderColor: "transparent"
                }]
            },
            options: {
                maintainAspectRatio: false,
                plugins: {
                        tooltip: {
                            enabled: true,  // Show tooltips on hover
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `Total revenue: {{$amountCurrencyCode}} ${tooltipItem.raw}`;  // Custom label for tooltips
                                }
                            }
                        },
                        legend: {
                            display: true,  // Display the legend (set to false if you want to hide it)
                            position: 'top'  // Position of the legend
                        }
                    }
            }
        });

        //pie cart LOB wise Revenue Share of currrent Month
        new Chart(document.getElementById("pie-chart-lob-share-revenue"), {
            type: "pie", 
            data: {
                labels: revenueLabels,
                datasets: [{
                    data: partnerRevenue,
                    backgroundColor: [
                        '#38a7a3',  
                        '#da9138',  
                        '#dc3545',
                        '#716aad', 
                        '#4BC0C0',  
                        '#8C8C',
                        '#f3e9cb'
                    ],
                    borderColor: "transparent"
                }]
            },
            options: {
                maintainAspectRatio: false,
                plugins: {
                        tooltip: {
                            enabled: true,  // Show tooltips on hover
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `partner revenue share: {{$amountCurrencyCode}} ${tooltipItem.raw}`;  // Custom label for tooltips
                                }
                            }
                        },
                        legend: {
                            display: true,  // Display the legend (set to false if you want to hide it)
                            position: 'top'  // Position of the legend
                        }
                    }
            }
        });
    @endif

    @if($revenueGenerated12Months)
        //12 month revenue generated trend
        let revenueChart;
        const revenueGenerated12Months = @json($revenueGenerated12Months);
        function revenueGeneratedMonthBarChart(slug=1){
            
            if (revenueChart) {
                revenueChart.destroy();
            }
            let listData=revenueGenerated12Months[slug-1]['data'];
            const revenueGenerated12MonthsLabels = listData.map(data => [data.name]);
            const revenueGenerated12MonthsTotal =listData.map(data => [data.total]);
            const revenueGenerated12MonthsPartner = listData.map(data => [data.partner]);
            // bar chart 12th month revenue generated trend
            revenueChart=new Chart(document.getElementById("subscription-12-months-revenue"), {
                type: "bar",
                height:500,
                width:320,
                data: {
                    labels: revenueGenerated12MonthsLabels,
                    datasets: [{
                        label: "Total",
                        backgroundColor: '#38a7a3',  
                        borderColor: '#38a7a3',
                        hoverBackgroundColor: '#38a7a3',
                        hoverBorderColor: '#38a7a3',
                        data: revenueGenerated12MonthsTotal,
                        barPercentage: 0.75,
                        categoryPercentage: 0.5
                    }, {
                        label: "Partner",
                        backgroundColor: "#da9138",
                        borderColor: "#da9138",
                        hoverBackgroundColor: "#da9138",
                        hoverBorderColor: "#da9138",
                        data: revenueGenerated12MonthsPartner,
                        barPercentage: 0.75,
                        categoryPercentage: 0.5
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                            grid: {
                                display: false,
                                color: "transparent"
                            }
                        },
                        y: {
                            stacked: true,
                            grid: {
                                display: false
                            },
                            ticks: {
                                beginAtZero: true,  // Ensure y-axis starts from 0
                                stepSize: 10        // Adjust steps on the y-axis
                            }
                        }
                    },
                    plugins: {
                        tooltip: {
                            enabled: true,  // Show tooltips on hover
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `Revenue: {{$amountCurrencyCode}} ${tooltipItem.raw}`;  // Custom label for tooltips
                                }
                            }
                        },
                        legend: {
                            display: true,  // Display the legend (set to false if you want to hide it)
                            position: 'top'  // Position of the legend
                        }
                    }
                }
            });
        }
        revenueGeneratedMonthBarChart();

        //LOB wise Customer
        let activeUserChart;
        const activeUser12Months = @json($revenueGenerated12Months);
        function activeUserMonthBarChart(slug=1){
            
            if (activeUserChart) {
                activeUserChart.destroy();
            }
            let listData=activeUser12Months[slug-1]['data'];
            const activeUser12MonthsLabels = listData.map(data => [data.name]);
            const activeUser12MonthsActiveUser =listData.map(data => [data.active_user]);
            // bar chart 12th month revenue generated trend
            activeUserChart=new Chart(document.getElementById("subscription-12-months-active-user"), {
                type: "bar",
                height:500,
                width:320,
                data: {
                    labels: activeUser12MonthsLabels,
                    datasets: [{
                        label: "Active Customer",
                        backgroundColor: '#38a7a3',  
                        borderColor: '#38a7a3',
                        hoverBackgroundColor: '#38a7a3',
                        hoverBorderColor: '#38a7a3',
                        data: activeUser12MonthsActiveUser,
                        barPercentage: 0.75,
                        categoryPercentage: 0.5
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                            grid: {
                                display: false,
                                color: "transparent"
                            }
                        },
                        y: {
                            stacked: true,
                            grid: {
                                display: false
                            },
                            ticks: {
                                beginAtZero: true,  // Ensure y-axis starts from 0
                                stepSize: 10        // Adjust steps on the y-axis
                            }
                        }
                    },
                    plugins: {
                        tooltip: {
                            enabled: true,  // Show tooltips on hover
                            callbacks: {
                                label: function(tooltipItem) {
                                    return `Customer: ${tooltipItem.raw}`;  // Custom label for tooltips
                                }
                            }
                        },
                        legend: {
                            display: true,  // Display the legend (set to false if you want to hide it)
                            position: 'top'  // Position of the legend
                        }
                    }
                }
            });
        }
        activeUserMonthBarChart();
    @endif

    @if($lobWiseSubscriptionEcommerce)
        const lobLabels1 = @json(collect($lobWiseSubscriptionEcommerce)->pluck('name'));
        const totalSubscriptions1 = @json(collect($lobWiseSubscriptionEcommerce)->pluck('total'));
        const totalthisWeekSubscriptions1 = @json(collect($lobWiseSubscriptionEcommerce)->pluck('week'));

        // bar chart Lob wise Customer
        new Chart(document.getElementById("bar-chart-lob-e-commerce"), {
            type: "bar",
            height:500,
            data: {
                labels: lobLabels1,
                datasets: [{
                    label: "Active",
                    backgroundColor: '#38a7a3',  // Bootstrap primary color
                    borderColor: '#38a7a3',
                    hoverBackgroundColor: '#38a7a3',
                    hoverBorderColor: '#38a7a3',
                    data: totalSubscriptions1,
                    barPercentage: 0.75,
                    categoryPercentage: 0.5
                }, {
                    label: "This Week Active",
                    backgroundColor: "#da9138",
                    borderColor: "#da9138",
                    hoverBackgroundColor: "#da9138",
                    hoverBorderColor: "#da9138",
                    data: totalthisWeekSubscriptions1,
                    barPercentage: 0.75,
                    categoryPercentage: 0.5
                }]
            },
            options: {
                responsive: true,
                scales: {
                    x: {  // x-axis configuration
                        stacked: true,
                        grid: {
                            display: false,
                            color: "transparent"
                        }
                    },
                    y: {  // y-axis configuration
                        stacked: true,
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
    @endif
</script>
@endsection
